package com.bizunited.empower.business.tenant.common.enums;

/**
 * OrderBusinessNumber 下单业务的二进制编号
 *
 * @Author: hefan
 * @Date: 2021/6/22 16:55
 */
public enum OrderBusinessNumber {

  /**
   * 客户自主下单
   */
  CUSTOMER_ORDERS_INDEPENDENTLY(0b1,"客户自主下单"),
  /**
   * 代客下单
   */
  VALET_ORDER(0b10,"代客下单"),
  /**
   * 访销开单
   */
  VISIT_SALES_ORDER(0b100,"访销开单"),
  /**
   * 车销开单
   */
  VEHICLE_SALES_ORDER(0b1000,"车销开单"),
  ;

  /**
   * 二进制编号
   */
  private int binaryNumber;

  /**
   * 下单业务名称
   */
  private String businessName;

  OrderBusinessNumber(int binaryNumber, String businessName) {
    this.binaryNumber = binaryNumber;
    this.businessName = businessName;
  }

  public int getBinaryNumber() {
    return binaryNumber;
  }

  public void setBinaryNumber(int binaryNumber) {
    this.binaryNumber = binaryNumber;
  }

  public String getBusinessName() {
    return businessName;
  }

  public void setBusinessName(String businessName) {
    this.businessName = businessName;
  }
}
