package com.bizunited.empower.business.tenant.common.enums;

/**
 * 经销商短信业务类型 1：解绑电子账户银行卡，2：电子账户提现，3：更改电子账户手机号码旧手机验证码，4：更改电子账户手机号码新手机验证码，
 * 5：新增电子账户手机号码，6：电子账户签约，7：绑定银行卡
 *
 * @Author: Paul Chan
 * @Date: 2021/4/17 上午10:32
 */
public enum TenantSmsBusinessType {
  EL_ACCOUNT_UNBIND_BANK(1, "", "解绑电子账户银行卡"),
  EL_ACCOUNT_WITHDRAW(2, "", "电子账户提现"),
  EL_ACCOUNT_MODIFY_MOBILE_OLD(3, "", "更改电子账户手机号码旧手机"),
  EL_ACCOUNT_MODIFY_MOBILE_NEW(4, "", "更改电子账户手机号码新手机"),
  EL_ACCOUNT_MOBILE_NEW(5, "", "新增电子账户手机号码"),
  EL_ACCOUNT_SIGN(6, "", "电子账户签约"),
  EL_ACCOUNT_BIND_BANK_CARD(7, "", "绑定银行卡");

  /**
   * 类型
   */
  private Integer type;

  /**
   * 短信模版
   */
  private String template;

  /**
   * 说明
   */
  private String desc;

  TenantSmsBusinessType(Integer type, String template, String desc) {
    this.type = type;
    this.template = template;
    this.desc = desc;
  }

  /**
   * 根据type值获取枚举
   * @return
   */
  public static TenantSmsBusinessType valueOfType(Integer type) {
    if(type == null) {
      return null;
    }
    for (TenantSmsBusinessType value : values()) {
      if(value.getType().equals(type)) {
        return value;
      }
    }
    return null;
  }

  public Integer getType() {
    return type;
  }

  public String getTemplate() {
    return template;
  }

  public String getDesc() {
    return desc;
  }
}
