package com.bizunited.empower.business.tenant.common.enums;

/**
 * WarehouseDisplayOption 客户订货端的库存显示
 *
 * @Author: hefan
 * @Date: 2021/6/23 11:05
 */
public enum WarehouseDisplayOption {

  /**
   * 显示库存数量
   */
  SHOW(1, "显示库存数量"),
  /**
   * 不显示库存
   */
  NOT_SHOW(2, "不显示库存"),
  /**
   * 自定义显示语
   */
  CUSTOMIZE(3, "自定义显示语");

  private Integer num;

  private String desc;

  WarehouseDisplayOption(Integer num, String desc) {
    this.num = num;
    this.desc = desc;
  }

  public Integer getNum() {
    return num;
  }

  public String getDesc() {
    return desc;
  }
}
