package com.bizunited.empower.business.tenant.controller;

import com.bizunited.empower.business.tenant.dto.TenantInfoDto;
import com.bizunited.empower.business.tenant.entity.TenantInfo;
import com.bizunited.empower.business.tenant.service.TenantInfoService;
import com.bizunited.empower.business.tenant.vo.TenantInfoVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.script.context.InvokeParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * TenantInfo业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/tenantInfo")
public class TenantInfoController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(TenantInfoController.class);
  
  @Autowired
  private TenantInfoService tenantInfoService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建tenantInfo中的基本信息以外，还可以对tenantInfo中属于OneToMany关联的明细信息一同进行创建注意：基于（TenantInfo）模型的创建操作传入的tenantInfoJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建tenantInfo中的基本信息以外，还可以对tenantInfo中属于OneToMany关联的明细信息一同进行创建注意：基于（TenantInfo）模型的创建操作传入的tenantInfoJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="tenantInfo" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建tenantInfo中的基本信息以外，还可以对tenantInfo中属于OneToMany关联的明细信息一同进行创建注意：基于（TenantInfo）模型的创建操作传入的tenantInfoJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") TenantInfoDto tenantInfoDto) {
    try {
      TenantInfo current = this.tenantInfoService.create(tenantInfoDto);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（TenantInfo）的修改操作传入的tenantInfoJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（TenantInfo）的修改操作传入的tenantInfoJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="tenantInfoDto" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（TenantInfo）的修改操作传入的tenantInfoJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") TenantInfoDto tenantInfoDto) {
    try {
      TenantInfo current = this.tenantInfoService.update(tenantInfoDto);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value="/{id}")
  public ResponseModel findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      TenantInfo current = this.tenantInfoService.findById(id);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照TenantInfo实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照TenantInfo实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      TenantInfo result = this.tenantInfoService.findDetailsById(id); 
      return this.buildHttpResultW(result, new String[]{}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }

  /**
   * 按照TenantInfo实体中的（code）进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param code 租户编号
   */
  @ApiOperation(value = "按照TenantInfo实体中的（code）进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findByCode" , method={RequestMethod.GET})
  public ResponseModel findByCode(@RequestParam("code") @ApiParam("租户编号") String code){
    try {
      TenantInfo result = this.tenantInfoService.findByCode(code);
      return this.buildHttpResultW(result, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 多条件分页查询
   * @param pageable
   * @param keyword
   * @return
   */
  @GetMapping("findByConditions")
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findByConditions(@PageableDefault(50) Pageable pageable,
                                        @RequestParam(required = false) @ApiParam("关键字,租户编号/租户名称") String keyword) {
    try {
      InvokeParams conditions = new InvokeParams();
      conditions.putInvokeParam("keyword", keyword);
      Page<TenantInfo> page = this.tenantInfoService.findByConditions(pageable, conditions);
      return this.buildHttpResultW(page,new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据登录用户手机号获取登录账号关联的经销商
   * @param phone
   * @return
   */
  @GetMapping("findByUserPhone")
  @ApiOperation("根据登录用户手机号获取登录账号关联的经销商")
  public ResponseModel findByUserPhone(@RequestParam @ApiParam("登录用户手机号") String phone) {
    try {
      List<TenantInfo> tenantInfos = this.tenantInfoService.findByUserPhone(phone);
      return this.buildHttpResultW(tenantInfos);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据登录用户账号获取登录账号关联的经销商
   * @param account
   * @return
   */
  @GetMapping("findByUserAccount")
  @ApiOperation("根据登录用户账号获取登录账号关联的经销商")
  public ResponseModel findByUserAccount(@RequestParam @ApiParam("登录用户手机号") String account) {
    try {
      List<TenantInfo> tenantInfos = this.tenantInfoService.findByUserAccount(account);
      return this.buildHttpResultW(tenantInfos);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 切换当前登录账号的经销商信息
   * @param tenantCode
   * @return
   */
  @PostMapping("switchTenant")
  @ApiOperation("切换当前登录账号的经销商信息")
  public ResponseModel switchTenant(@RequestParam @ApiParam("经销商编码") String tenantCode) {
    try {
      TenantInfoVo tenantInfoVo = this.tenantInfoService.switchTenant(tenantCode);
      return this.buildHttpResultW(tenantInfoVo);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 获取品牌登录页logo(无需鉴权，根据appcode获取)
   * @return
   */
  @GetMapping("findLoginLogoByAppCode")
  @ApiOperation("获取品牌登录页logo(无需鉴权，根据appcode获取)")
  public ResponseModel findLoginLogoByAppCode() {
    try {
      TenantInfoVo tenantInfoVo = this.tenantInfoService.findLoginLogoByAppCode();
      return this.buildHttpResultW(tenantInfoVo);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
  
  /**
   * 获取经销商logo（系统首页位置，根据登录用户的tenantCode获取）
   * @return
   */
  @GetMapping("findTenantLogoByTenantCode")
  @ApiOperation("获取经销商logo（系统首页位置，根据登录用户的tenantCode获取）")
  public ResponseModel findTenantLogoByTenantCode() {
    try {
      TenantInfoVo tenantInfoVo = this.tenantInfoService.findTenantLogoByTenantCode();
      return this.buildHttpResultW(tenantInfoVo);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 获取品牌商下的所有租户状态为：正常 的经销商
   * @return
   */
  @GetMapping("findTenantInfos")
  @ApiOperation("获取品牌商下的所有租户状态为：正常 的经销商")
  public ResponseModel findTenantInfos() {
    try {
      List<TenantInfo> tenantInfos = this.tenantInfoService.findTenantInfos();
      return this.buildHttpResultW(tenantInfos);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
} 
