package com.bizunited.empower.business.tenant.entity;

import com.bizunited.platform.common.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

@ApiModel(value = "TenantInfo", description = "租户信息")
@Entity
@Table(name="`tenant_info`",indexes ={@Index(columnList = "tenant_code", unique = true),
                                      @Index(columnList = "tenant_name", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "`tenant_info`", comment = "租户信息")
@BuildCustomRepository
public class TenantInfo extends UuidOpEntity {
  /**
   *
   */
  private static final long serialVersionUID = -4719932672444718135L;

  /** 租户名称 */
  @Column(name = "tenant_name", nullable = false, length=255 , columnDefinition = "VARCHAR(255) COMMENT ' 租户名称 '")
  @SaturnColumn(description = "租户名称")
  @ApiModelProperty("租户名称")
  private String tenantName;

  /** 租户编码 */
  @Column(name = "tenant_code", nullable = false,  length=64 , columnDefinition = "VARCHAR(64) COMMENT ' 租户编码 '")
  @SaturnColumn(description = "租户编码")
  @ApiModelProperty("租户编码")
  private String tenantCode;

  /** 租户状态 */
  @Column(name = "tenant_status", nullable = false,  length=1 , columnDefinition = "tinyint(1) COMMENT ' 租户状态 '")
  @SaturnColumn(description = "租户状态")
  @ApiModelProperty("租户状态")
  private Boolean tenantStatus;

  /** 租户类型 */
  @Column(name = "tenant_type", nullable = false,  length=32 , columnDefinition = "VARCHAR(32) COMMENT ' 租户类型 '")
  @SaturnColumn(description = "租户类型")
  @ApiModelProperty("租户类型")
  private String tenantType;

  /** 租户有效期 */
  @Column(name = "tenant_expired", nullable = false, columnDefinition = "DATETIME COMMENT ' 租户有效期 '")
  @SaturnColumn(description = "租户有效期")
  @ApiModelProperty("租户有效期")
  @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
  private Date tenantExpired;

  /** 租户介绍 */
  @Column(name = "tenant_description", nullable = true,  length=1024 , columnDefinition = "VARCHAR(1024) COMMENT ' 租户介绍 '")
  @SaturnColumn(description = "租户介绍")
  @ApiModelProperty("租户介绍")
  private String tenantDescription;

  /** logo相对路径 */
  @Column(name = "logo_relative_path", nullable = true,  length=1024 , columnDefinition = "VARCHAR(1024) COMMENT ' logo相对路径 '")
  @SaturnColumn(description = "logo相对路径")
  @ApiModelProperty("logo相对路径")
  private String logoRelativePath;

  /** logo文件名 */
  @Column(name = "logo_file_name", nullable = true,  length=1024 , columnDefinition = "VARCHAR(1024) COMMENT ' logo文件名 '")
  @SaturnColumn(description = "logo文件名")
  @ApiModelProperty("logo文件名")
  private String logoFileName;

  /** 网页标签icon相对路径 */
  @Column(name = "icon_relative_path", nullable = true,  length=255 , columnDefinition = "VARCHAR(255) COMMENT ' icon相对路径 '")
  @SaturnColumn(description = "icon相对路径")
  @ApiModelProperty("网页标签icon相对路径")
  private String iconRelativePath;

  /** 网页标签icon文件名 */
  @Column(name = "icon_file_name", nullable = true,  length=255 , columnDefinition = "VARCHAR(255) COMMENT ' icon文件名 '")
  @SaturnColumn(description = "icon文件名")
  @ApiModelProperty("网页标签icon文件名")
  private String iconFileName;

  /** 登录页logo相对路径 */
  @Column(name = "login_relative_path", nullable = true,  length=255 , columnDefinition = "VARCHAR(255) COMMENT ' logo相对路径 '")
  @SaturnColumn(description = "logo相对路径")
  @ApiModelProperty("登录页logo相对路径")
  private String loginLogoRelativePath;

  /** 登录页logo文件名 */
  @Column(name = "login_file_name", nullable = true,  length=255 , columnDefinition = "VARCHAR(255) COMMENT ' logo文件名 '")
  @SaturnColumn(description = "logo文件名")
  @ApiModelProperty("登录页logo文件名")
  private String loginLogoFileName;

  /** 品牌商租户编码 */
  @Column(name = "app_code", nullable = false,  length=255 , columnDefinition = "VARCHAR(255) COMMENT ' 品牌商租户编码 '")
  @SaturnColumn(description = "品牌商租户编码")
  @ApiModelProperty("品牌商租户编码")
  private String appCode;

  public String getTenantName(){
    return this.tenantName;
  }

  public void setTenantName(String tenantName){
    this.tenantName = tenantName;
  }

  public String getTenantCode(){
    return this.tenantCode;
  }

  public void setTenantCode(String tenantCode){
    this.tenantCode = tenantCode;
  }

  public Boolean getTenantStatus(){
    return this.tenantStatus;
  }

  public void setTenantStatus(Boolean tenantStatus){
    this.tenantStatus = tenantStatus;
  }

  public String getTenantType(){
    return this.tenantType;
  }

  public void setTenantType(String tenantType){
    this.tenantType = tenantType;
  }

  public Date getTenantExpired(){
    return this.tenantExpired;
  }

  public void setTenantExpired(Date tenantExpired){
    this.tenantExpired = tenantExpired;
  }

  public String getTenantDescription(){
    return this.tenantDescription;
  }

  public void setTenantDescription(String tenantDescription){
    this.tenantDescription = tenantDescription;
  }

  public String getLogoRelativePath(){
    return this.logoRelativePath;
  }

  public void setLogoRelativePath(String logoRelativePath){
    this.logoRelativePath = logoRelativePath;
  }

  public String getLogoFileName() {
    return logoFileName;
  }

  public String getIconRelativePath() {
    return iconRelativePath;
  }

  public void setIconRelativePath(String iconRelativePath) {
    this.iconRelativePath = iconRelativePath;
  }

  public String getIconFileName() {
    return iconFileName;
  }

  public void setIconFileName(String iconFileName) {
    this.iconFileName = iconFileName;
  }

  public String getLoginLogoRelativePath() {
    return loginLogoRelativePath;
  }

  public void setLoginLogoRelativePath(String loginLogoRelativePath) {
    this.loginLogoRelativePath = loginLogoRelativePath;
  }

  public String getLoginLogoFileName() {
    return loginLogoFileName;
  }

  public void setLoginLogoFileName(String loginLogoFileName) {
    this.loginLogoFileName = loginLogoFileName;
  }

  public void setLogoFileName(String logoFileName){
    this.logoFileName = logoFileName;
  }

  public String getAppCode() {
    return appCode;
  }

  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }
}