package com.bizunited.empower.business.tenant.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * TenantProcessingFlowSetting 租户处理流程配置信息
 *
 * @Author: hefan
 * @Date: 2021/6/22 14:51
 */
@ApiModel(value = "TenantProcessingFlowSetting", description = "租户处理流程配置信息")
@Entity
@Table(name = "`tenant_processing_flow_setting`", indexes ={@Index(columnList = "tenant_code,processing_flow_type,node_number", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "`tenant_processing_flow_setting`", comment = "租户处理流程配置信息")
public class TenantProcessingFlowSetting extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -5271043755878882567L;
  /**
   *  处理流程类型 参考枚举：ProcessingFlowType
   */
  @ApiModelProperty("处理流程类型 参考枚举：ProcessingFlowType")
  @SaturnColumn(description = "处理流程类型 参考枚举：ProcessingFlowType")
  @Column(name = "processing_flow_type", nullable = false, columnDefinition = "INT(11) COMMENT '处理流程类型 参考枚举：ProcessingFlowType'")
  private Integer processingFlowType;

  /**
   * 处理流程名称
   */
  @ApiModelProperty("处理流程名称")
  @SaturnColumn(description = "处理流程名称")
  @Column(name = "processing_flow_name", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 处理流程名称 '")
  private String processingFlowName;

  /**
   *  处理流程节点编号 参考枚举：ProcessingFlowNodeNumber
   */
  @ApiModelProperty("处理流程节点编号 参考枚举：ProcessingFlowNodeNumber")
  @SaturnColumn(description = "处理流程节点编号 参考枚举：ProcessingFlowNodeNumber")
  @Column(name = "node_number", nullable = false, columnDefinition = "INT(11) COMMENT '处理流程节点编号 参考枚举：ProcessingFlowNodeNumber'")
  private Integer nodeNumber;

  /**
   * 处理流程节点名称
   */
  @ApiModelProperty("处理流程节点名称")
  @SaturnColumn(description = "处理流程节点名称")
  @Column(name = "node_name", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 处理流程节点名称 '")
  private String nodeName;

  /**
   * 节点状态
   */
  @ApiModelProperty("节点状态")
  @SaturnColumn(description = "节点状态")
  @Column(name = "node_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 节点状态 '")
  private Boolean nodeStatus;

  /**
   * 租户信息
   */
  @ApiModelProperty("租户信息")
  @SaturnColumn(description = "租户信息")
  @Column(name = "tenant_code", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 租户编号 '")
  private String tenantCode;


  public Integer getProcessingFlowType() {
    return processingFlowType;
  }

  public void setProcessingFlowType(Integer processingFlowType) {
    this.processingFlowType = processingFlowType;
  }

  public String getProcessingFlowName() {
    return processingFlowName;
  }

  public void setProcessingFlowName(String processingFlowName) {
    this.processingFlowName = processingFlowName;
  }

  public Integer getNodeNumber() {
    return nodeNumber;
  }

  public void setNodeNumber(Integer nodeNumber) {
    this.nodeNumber = nodeNumber;
  }

  public String getNodeName() {
    return nodeName;
  }

  public void setNodeName(String nodeName) {
    this.nodeName = nodeName;
  }

  public Boolean getNodeStatus() {
    return nodeStatus;
  }

  public void setNodeStatus(Boolean nodeStatus) {
    this.nodeStatus = nodeStatus;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
}
