package com.bizunited.empower.business.tenant.feign;

import com.bizunited.empower.business.tenant.dto.DealerInfoDto;
import com.bizunited.empower.business.tenant.feign.fallback.DealerInfoFeignClientFallback;
import com.bizunited.platform.common.controller.model.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 经销商信息远程调用客户端
 * @Author: Paul Chan
 * @Date: 2021/5/27 下午2:07
 */
@FeignClient(name = "saas-dealerInfo", url = "${saas.baseUrl}", path = "/v1/dealerInfo", fallback = DealerInfoFeignClientFallback.class)
public interface DealerInfoFeignClient {

  /**
   * 创建
   * @param dealerInfoDto
   * @return
   */
  @PostMapping("")
  ResponseModel create(@RequestBody DealerInfoDto dealerInfoDto);

}
