package com.bizunited.empower.business.tenant.repository;

import com.bizunited.empower.business.tenant.entity.TenantInfo;
import com.bizunited.empower.business.tenant.repository.internal.TenantInfoRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * TenantInfo业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_TenantInfoRepository")
public interface TenantInfoRepository
    extends
    JpaRepository<TenantInfo, String>
    , JpaSpecificationExecutor<TenantInfo>
    , TenantInfoRepositoryCustom {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct tenantInfo from TenantInfo tenantInfo "
      + " where tenantInfo.id=:id ")
  TenantInfo findDetailsById(@Param("id") String id);


  /**
   * 按照租户进行查询
   *
   * @param code
   * @return
   */
  @Query("select distinct tenantInfo from TenantInfo tenantInfo "
      + " where tenantInfo.tenantCode=:code ")
  TenantInfo findByCode(@Param("code") String code);

  /**
   * 根据厂商编码查询经销商
   *
   * @param appCode
   * @return
   */
  @Query("select distinct tenantInfo from TenantInfo tenantInfo "
          + " where tenantInfo.tenantStatus=:tenantStatus and tenantInfo.appCode=:appCode ")
  List<TenantInfo> findByTenantStatusAndAppCode(@Param("tenantStatus") Boolean tenantStatus, @Param("appCode") String appCode);

  /**
   * 根据厂商编码查询经销商
   *
   * @param appCode
   * @return
   */
  List<TenantInfo> findByAppCode(@Param("appCode") String appCode);

  /**
   * 根据编码统计
   * @param tenantCode
   * @return
   */
  long countByTenantCode(String tenantCode);

  /**
   * 根据名称统计
   *
   * @param tenantName
   * @return
   */
  long countByTenantName(String tenantName);

  /**
   * 根据编码集合查询
   * @param tenantCodes
   * @return
   */
  @Query("select t from TenantInfo t where t.tenantCode in :tenantCodes order by t.createTime asc ")
  List<TenantInfo> findByCodes(@Param("tenantCodes") List<String> tenantCodes);
}
