package com.bizunited.empower.business.tenant.repository;
import com.bizunited.empower.business.tenant.entity.TenantSetting;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * TenantSetting业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_TenantSettingRepository")
public interface TenantSettingRepository
    extends
      JpaRepository<TenantSetting, String>
      ,JpaSpecificationExecutor<TenantSetting>
  {
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct tenantSetting from TenantSetting tenantSetting "
      + " where tenantSetting.id=:id ")
  TenantSetting findDetailsById(@Param("id") String id);

  /**
   * 按照租户编码查询配置信息
   * @param tenantCode
   * @return
   */
  @Query("select distinct tenantSetting from TenantSetting tenantSetting "
      + " where tenantSetting.tenantCode=:tenantCode ")
  TenantSetting findByTenantCode(@Param("tenantCode") String tenantCode);

}