package com.bizunited.empower.business.tenant.repository;
import com.bizunited.empower.business.tenant.entity.TenantTerminalSetting;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * TenantTerminalSetting业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_TenantTerminalSettingRepository")
public interface TenantTerminalSettingRepository
    extends
      JpaRepository<TenantTerminalSetting, String>
      ,JpaSpecificationExecutor<TenantTerminalSetting>
  {
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct tenantTerminalSetting from TenantTerminalSetting tenantTerminalSetting "
      + " where tenantTerminalSetting.id=:id ")
  TenantTerminalSetting findDetailsById(@Param("id") String id);

  @Query("select distinct tenantTerminalSetting from TenantTerminalSetting tenantTerminalSetting "
          + " where tenantTerminalSetting.appCode=:appCpde ")
  List<TenantTerminalSetting> findByAppCode(@Param("appCpde") String appCpde);

  @Query("select distinct tenantTerminalSetting from TenantTerminalSetting tenantTerminalSetting "
          + " where tenantTerminalSetting.appCode=:appCpde and tenantTerminalSetting.appType=:appType")
  TenantTerminalSetting findByAppCodeAndAppType(@Param("appCpde")String appCode, @Param("appType")Integer appType);
}