package com.bizunited.empower.business.tenant.service;

import com.bizunited.empower.business.tenant.common.enums.TenantSettingSwitchEnum;
import com.bizunited.empower.business.tenant.entity.TenantSetting;
import com.bizunited.empower.business.tenant.vo.TenantSettingVo;

/**
 * TenantSettingVo业务模型的服务层接口定义
 *
 * @author saturn
 */
public interface TenantSettingVoService {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  TenantSettingVo findDetailsVoById(String id);

  /**
   * 根据登录用户信息的TenantCode，以及指定的设置枚举查询该枚举是否开启
   * tenantSettingSwitchEnum 租户指定设置枚举
   */
  TenantSettingVo findTenantSettingSwitchByEnum(TenantSettingSwitchEnum tenantSettingSwitchEnum);

  /**
   * 根据租户编号以及指定的设置枚举查询该枚举是否开启
   * tenantSettingSwitchEnum 租户指定设置枚举
   * @param tenantCode
   * @param tenantSettingSwitchEnum
   * @return
   */
  TenantSettingVo findTenantSettingSwitchByEnum(String tenantCode,TenantSettingSwitchEnum tenantSettingSwitchEnum);

  /**
   * 根据登录用户信息的TenantCode进行明细查询
   */
  TenantSettingVo findByTenantCode();

  /**
   * 根据主键id获取数据
   */
  TenantSettingVo findById(String id);

  /**
   * 获取经销商logo（系统首页位置）
   */
  TenantSettingVo findSettingImgByTenantCode();
}
