package com.bizunited.empower.business.tenant.service.internal;

import com.bizunited.empower.business.common.util.ResponseModelUtils;
import com.bizunited.empower.business.tenant.dto.DealerInfoDto;
import com.bizunited.empower.business.tenant.entity.TenantInfo;
import com.bizunited.empower.business.tenant.feign.DealerInfoFeignClient;
import com.bizunited.empower.business.tenant.service.DealerInfoDtoService;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.empower.business.common.util.SecurityUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * saas 经销商服务实现
 * @Author: Paul Chan
 * @Date: 2021/5/27 下午2:21
 */
@Service
public class DealerInfoDtoServiceImpl implements DealerInfoDtoService {

  @Autowired
  private DealerInfoFeignClient dealerInfoFeignClient;

  @Override
  public void create(TenantInfo tenantInfo) {
    Validate.notNull(tenantInfo, "经销商信息不能为空");
    DealerInfoDto dto = new DealerInfoDto();
    dto.setTenantCode(tenantInfo.getTenantCode());
    dto.setTenantName(tenantInfo.getTenantName());
    dto.setRemark(tenantInfo.getTenantDescription());
    dto.setAppCode(tenantInfo.getAppCode());
    dto.setCreateAccount(SecurityUtils.getUserAccount());
    ResponseModel responseModel = dealerInfoFeignClient.create(dto);
    ResponseModelUtils.validSuccess(responseModel);
  }
}
