package com.bizunited.empower.business.tenant.service.internal;

import com.bizunited.empower.business.tenant.common.enums.BrowseProductRuleEnum;
import com.bizunited.empower.business.tenant.common.enums.TenantSettingSwitchEnum;
import com.bizunited.empower.business.tenant.entity.TenantSetting;
import com.bizunited.empower.business.tenant.service.TenantSettingService;
import com.bizunited.empower.business.tenant.service.TenantSettingVoService;
import com.bizunited.empower.business.tenant.utils.TenantSettingEnumUtil;
import com.bizunited.empower.business.tenant.vo.TenantSettingVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

@Service("TenantSettingVoServiceImpl")
public class TenantSettingVoServiceImpl implements TenantSettingVoService {
  @Autowired
  private TenantSettingService tenantSettingService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;


  @Override
  public TenantSettingVo findDetailsVoById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }

    TenantSetting tenantSetting = tenantSettingService.findById(id);
    if (Objects.isNull(tenantSetting)) {
      return null;
    }

    TenantSettingVo current = nebulaToolkitService.copyObjectByWhiteList(tenantSetting,TenantSettingVo.class, HashSet.class, ArrayList.class);
    Map<TenantSettingSwitchEnum, Integer> configSwitchEnumsByConfig = TenantSettingEnumUtil.getSettingSwitchEnumsBySetting(tenantSetting.getBaseSettingSwitch());
    current.setBaseSettingSwitchMap(configSwitchEnumsByConfig);
    return current;
  }

  @Override
  public TenantSettingVo findTenantSettingSwitchByEnum(TenantSettingSwitchEnum tenantSettingSwitchEnum) {
    if (Objects.isNull(tenantSettingSwitchEnum)) {
      return null;
    }

    TenantSetting tenantSetting = tenantSettingService.findByTenantCode(TenantUtils.getTenantCode());
    if (Objects.isNull(tenantSetting)) {
      return null;
    }

    TenantSettingVo current = new TenantSettingVo();
    Integer configIsEnableByNum = TenantSettingEnumUtil.getSettingIsEnableByNum(tenantSetting.getBaseSettingSwitch(), tenantSettingSwitchEnum);
    if(configIsEnableByNum == null){
      return null;
    }
    current.setBaseSettingSwitchMap(ImmutableMap.of(tenantSettingSwitchEnum, configIsEnableByNum));
    return current;
  }

  @Override
  public TenantSettingVo findTenantSettingSwitchByEnum(String tenantCode, TenantSettingSwitchEnum tenantSettingSwitchEnum) {
    if (Objects.isNull(tenantSettingSwitchEnum) || StringUtils.isBlank(tenantCode)) {
      return null;
    }

    TenantSetting tenantSetting = tenantSettingService.findByTenantCode(tenantCode);
    if (Objects.isNull(tenantSetting)) {
      return null;
    }

    TenantSettingVo current = new TenantSettingVo();
    Integer configIsEnableByNum = TenantSettingEnumUtil.getSettingIsEnableByNum(tenantSetting.getBaseSettingSwitch(), tenantSettingSwitchEnum);
    if(configIsEnableByNum == null){
      return null;
    }
    current.setBaseSettingSwitchMap(ImmutableMap.of(tenantSettingSwitchEnum, configIsEnableByNum));
    return current;
  }


  @Override
  public TenantSettingVo findByTenantCode() {
    TenantSetting tenantSetting = tenantSettingService.findByTenantCode(TenantUtils.getTenantCode());
    if (Objects.isNull(tenantSetting)) {
      return null;
    }

    TenantSettingVo current = nebulaToolkitService.copyObjectByWhiteList(tenantSetting,
            TenantSettingVo.class, HashSet.class, ArrayList.class);
    Map<TenantSettingSwitchEnum, Integer> configSwitchEnumsByConfig =
            TenantSettingEnumUtil.getSettingSwitchEnumsBySetting(tenantSetting.getBaseSettingSwitch());
    current.setBaseSettingSwitchMap(configSwitchEnumsByConfig);

    return current;
  }

  @Override
  public TenantSettingVo findById(String id) {
    if(StringUtils.isBlank(id)){
      return null;
    }
    TenantSetting tenantSetting = tenantSettingService.findById(id);
    if(tenantSetting == null){
      return null;
    }
    return nebulaToolkitService.copyObjectByWhiteList(tenantSetting,TenantSettingVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public TenantSettingVo findSettingImgByTenantCode() {
    String tenantCode = TenantUtils.getTenantCode();
    if(StringUtils.isBlank(tenantCode)){
      return null;
    }
    TenantSetting tenantSetting = tenantSettingService.findByTenantCode(tenantCode);
    return nebulaToolkitService.copyObjectByWhiteList(tenantSetting,TenantSettingVo.class, HashSet.class, ArrayList.class);
  }
}
