package com.bizunited.empower.business.tenant.service.internal;
import com.bizunited.empower.business.tenant.entity.TenantTerminalSetting;
import com.bizunited.empower.business.tenant.repository.TenantTerminalSettingRepository;
import com.bizunited.empower.business.tenant.service.TenantTerminalSettingService;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * TenantTerminalSetting业务模型的服务层接口实现
 * @author saturn
 */
@Service("TenantTerminalSettingServiceImpl")
public class TenantTerminalSettingServiceImpl implements TenantTerminalSettingService { 
  @Autowired
  private TenantTerminalSettingRepository tenantTerminalSettingRepository;
  @Transactional
  @Override
  public TenantTerminalSetting create(TenantTerminalSetting tenantTerminalSetting) { 
    TenantTerminalSetting current = this.createForm(tenantTerminalSetting);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public TenantTerminalSetting createForm(TenantTerminalSetting tenantTerminalSetting) { 
   /* 
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    Date now = new Date();
    tenantTerminalSetting.setCreateAccount(SecurityUtils.getUserAccount());
    tenantTerminalSetting.setCreateTime(now);
    tenantTerminalSetting.setModifyAccount(SecurityUtils.getUserAccount());
    tenantTerminalSetting.setModifyTime(now);

    this.createValidation(tenantTerminalSetting);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    
    this.tenantTerminalSettingRepository.save(tenantTerminalSetting);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return tenantTerminalSetting;
  }
  /**
   * 在创建一个新的TenantTerminalSetting模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(TenantTerminalSetting tenantTerminalSetting) { 
    Validate.notNull(tenantTerminalSetting , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(tenantTerminalSetting.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    tenantTerminalSetting.setId(null);
    Validate.notBlank(tenantTerminalSetting.getMiniAppID(), "添加信息时，小程序id不能为空！");
    Validate.notBlank(tenantTerminalSetting.getMiniAppSecret(), "添加信息时，小程序secret不能为空！");
    Validate.notNull(tenantTerminalSetting.getAppType(), "添加信息时，应用类型不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(tenantTerminalSetting.getMiniName() == null || tenantTerminalSetting.getMiniName().length() < 255 , "小程序名称,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(tenantTerminalSetting.getMiniAppID() == null || tenantTerminalSetting.getMiniAppID().length() < 255 , "小程序id,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(tenantTerminalSetting.getMiniAppSecret() == null || tenantTerminalSetting.getMiniAppSecret().length() < 255 , "小程序secret,在进行添加时填入值超过了限定长度(255)，请检查!");
  }
  @Transactional
  @Override
  public TenantTerminalSetting update(TenantTerminalSetting tenantTerminalSetting) { 
    TenantTerminalSetting current = this.updateForm(tenantTerminalSetting);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public TenantTerminalSetting updateForm(TenantTerminalSetting tenantTerminalSetting) { 
    /* 
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     * 
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    
    this.updateValidation(tenantTerminalSetting);
    // ===================基本信息
    String currentId = tenantTerminalSetting.getId();
    Optional<TenantTerminalSetting> op_currentTenantTerminalSetting = this.tenantTerminalSettingRepository.findById(currentId);
    TenantTerminalSetting currentTenantTerminalSetting = op_currentTenantTerminalSetting.orElse(null);
    currentTenantTerminalSetting = Validate.notNull(currentTenantTerminalSetting ,"未发现指定的原始模型对象信");
    // 开始赋值——更新时间与更新人
    Date now = new Date();
    currentTenantTerminalSetting.setModifyAccount(SecurityUtils.getUserAccount());
    currentTenantTerminalSetting.setModifyTime(now);
    // 开始重新赋值——一般属性
    currentTenantTerminalSetting.setMiniName(tenantTerminalSetting.getMiniName());
    currentTenantTerminalSetting.setMiniAppID(tenantTerminalSetting.getMiniAppID());
    currentTenantTerminalSetting.setMiniAppSecret(tenantTerminalSetting.getMiniAppSecret());
    
    this.tenantTerminalSettingRepository.saveAndFlush(currentTenantTerminalSetting);
    return currentTenantTerminalSetting;
  }
  /**
   * 在更新一个已有的TenantTerminalSetting模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(TenantTerminalSetting tenantTerminalSetting) { 
    Validate.isTrue(!StringUtils.isBlank(tenantTerminalSetting.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(tenantTerminalSetting.getMiniAppID(), "修改信息时，小程序id不能为空！");
    Validate.notBlank(tenantTerminalSetting.getMiniAppSecret(), "修改信息时，小程序secret不能为空！");
    Validate.notNull(tenantTerminalSetting.getAppType(), "修改信息时，应用类型不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(tenantTerminalSetting.getMiniName() == null || tenantTerminalSetting.getMiniName().length() < 255 , "小程序名称,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(tenantTerminalSetting.getMiniAppID() == null || tenantTerminalSetting.getMiniAppID().length() < 255 , "小程序id,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(tenantTerminalSetting.getMiniAppSecret() == null || tenantTerminalSetting.getMiniAppSecret().length() < 255 , "小程序secret,在进行修改时填入值超过了限定长度(255)，请检查!");
    
    // 关联性判断，关联属性判断，需要满足ManyToOne或者OneToOne，且not null 且是主模型
  } 
  @Override
  public TenantTerminalSetting findDetailsById(String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.tenantTerminalSettingRepository.findDetailsById(id);
  }
  @Override
  public TenantTerminalSetting findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<TenantTerminalSetting> op = tenantTerminalSettingRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    TenantTerminalSetting current = this.findById(id);
    if(current != null) { 
      this.tenantTerminalSettingRepository.delete(current);
    }
  }

  @Override
  public List<TenantTerminalSetting> findByAppCode(String appCode) {
    if(StringUtils.isBlank(appCode)){
      return Lists.newArrayList();
    }
    return tenantTerminalSettingRepository.findByAppCode(appCode);
  }

  @Override
  public TenantTerminalSetting findByAppCodeAndAppType(String appCode, Integer appType) {
    if(StringUtils.isBlank(appCode) || appType == null){
      return null;
    }
    return tenantTerminalSettingRepository.findByAppCodeAndAppType(appCode,appType);
  }
} 
