package com.bizunited.empower.business.tenant.service.notifier;

import com.bizunited.empower.business.tenant.vo.TenantInfoVo;

/**
 * 租户信息初始化事件监听器
 *
 * @author Keller
 */
public interface TenantInitEventListener {

  /**
   * 获取排序信息，顺序排序
   * @return
   */
  default int getOrder() {
    return 100;
  }

  /**
   * 在初始化租户信息的场景时候，创建租户基础信息并通知相关功能模块，同步初始化数据
   */
  void onInitTenant(TenantInfoVo tenantInfoVo);

}
