package com.bizunited.empower.business.tenant.service.notifier;

import com.bizunited.empower.business.tenant.vo.TenantInfoVo;

/**
 * 租户状态变更监听器
 *
 * @author Keller
 */
public interface TenantStatusEventListener {

  /**
   * 激活租户状态通知，在租户状态变更为激活时候需要通知相关业务方对应的处理，传递参数为对应租户的基础信息
   * @param tenantInfoVo
   */
  void onEnable(TenantInfoVo tenantInfoVo);

  /**
   * 禁用租户状态通知，在租户状态变更为禁止时候需要通知相关业务方进行对应的数据处理，传递参数为对应租户的基础信息
   * @param tenantInfoVo
   */
  void onDisable(TenantInfoVo tenantInfoVo);
}
