package com.bizunited.empower.business.tenant.service.notifier;

import com.bizunited.empower.business.tenant.vo.TenantSettingVo;

/**
 * 租户仓库状态变更监听器
 * @author Keller
 */
public interface TenantWarehouseEventListener {

  /**
   * 实现类，只关心的属性发生了变化
   * @param tenantSettingVo
   * @return
   */
  Boolean iCare(TenantSettingVo tenantSettingVo);

  /**
   * 既然你关心，那你允许这个属性改变吗
   * 不允许改变，你就抛异常，并写清楚异常信息
   * 允许改变，你就让代码正常流转
   * @param tenantSettingVo
   */
  void pass(TenantSettingVo tenantSettingVo);

  /**
   * 判断该租户下所有的仓库是否都设置了销售区域
   * @param tenantCode
   * @return
   */
  void isSetArea(String tenantCode);

  /**
   * 租户状态变更通知，在租户状态进行变更时通知相关模型进行对应的调整
   * @param tenantSettingVo
   */
  default void onChange(TenantSettingVo tenantSettingVo){
    if (this.iCare(tenantSettingVo)){
      this.pass(tenantSettingVo);
    }
  }

}
