package com.bizunited.empower.business.tenant.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 租户信息
 * @author Keller
 */
@ApiModel(value = "TenantInfo", description = "租户信息主模型")
@SaturnEntity(name = "TenantInfoVo", description = "租户信息Vo")
public class TenantInfoVo extends UuidVo {
  /**
   * 
   */
  private static final long serialVersionUID = 685606853182396868L;
  /** 租户名称 */
  @SaturnColumn(description = "租户名称")
  @ApiModelProperty("租户名称")
  private String tenantName;

  /** 租户编码 */
  @SaturnColumn(description = "租户编码")
  @ApiModelProperty("租户编码")
  private String tenantCode;

  /** 租户状态 */
  @SaturnColumn(description = "租户状态")
  @ApiModelProperty("租户状态")
  private Boolean tenantStatus;

  /** 租户类型 */
  @SaturnColumn(description = "租户类型")
  @ApiModelProperty("租户类型")
  private String tenantType;

  /** 租户有效期 */
  @SaturnColumn(description = "租户有效期")
  @ApiModelProperty("租户有效期")
  @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
  private Date tenantExpired;

  /** 租户介绍 */
  @SaturnColumn(description = "租户介绍")
  @ApiModelProperty("租户介绍")
  private String tenantDescription;

  /** logo相对路径 */
  @SaturnColumn(description = "logo相对路径")
  @ApiModelProperty("logo相对路径")
  private String logoRelativePath;

  /** logo文件名 */
  @SaturnColumn(description = "logo文件名")
  @ApiModelProperty("logo文件名")
  private String logoFileName;

  /** 网页标签icon相对路径 */
  @SaturnColumn(description = "网页标签icon相对路径")
  @ApiModelProperty("网页标签icon相对路径")
  private String iconRelativePath;

  /** 网页标签icon文件名 */
  @SaturnColumn(description = "网页标签icon文件名")
  @ApiModelProperty("网页标签icon文件名")
  private String iconFileName;

  /** 登录页logo相对路径 */
  @SaturnColumn(description = "登录页logo相对路径")
  @ApiModelProperty("登录页logo相对路径")
  private String loginLogoRelativePath;

  /** 登录页logo文件名 */
  @SaturnColumn(description = "登录页logo文件名")
  @ApiModelProperty("登录页logo文件名")
  private String loginLogoFileName;

  /** 品牌商租户编号 */
  @SaturnColumn(description = "品牌商租户编号")
  @ApiModelProperty("品牌商租户编号")
  private String appCode;

  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public Boolean getTenantStatus() {
    return tenantStatus;
  }

  public void setTenantStatus(Boolean tenantStatus) {
    this.tenantStatus = tenantStatus;
  }

  public String getTenantType() {
    return tenantType;
  }

  public void setTenantType(String tenantType) {
    this.tenantType = tenantType;
  }

  public Date getTenantExpired() {
    return tenantExpired;
  }

  public void setTenantExpired(Date tenantExpired) {
    this.tenantExpired = tenantExpired;
  }

  public String getTenantDescription() {
    return tenantDescription;
  }

  public void setTenantDescription(String tenantDescription) {
    this.tenantDescription = tenantDescription;
  }

  public String getLogoRelativePath() {
    return logoRelativePath;
  }

  public void setLogoRelativePath(String logoRelativePath) {
    this.logoRelativePath = logoRelativePath;
  }

  public String getLogoFileName() {
    return logoFileName;
  }

  public void setLogoFileName(String logoFileName) {
    this.logoFileName = logoFileName;
  }

  public String getIconRelativePath() {
    return iconRelativePath;
  }

  public void setIconRelativePath(String iconRelativePath) {
    this.iconRelativePath = iconRelativePath;
  }

  public String getIconFileName() {
    return iconFileName;
  }

  public void setIconFileName(String iconFileName) {
    this.iconFileName = iconFileName;
  }

  public String getLoginLogoRelativePath() {
    return loginLogoRelativePath;
  }

  public void setLoginLogoRelativePath(String loginLogoRelativePath) {
    this.loginLogoRelativePath = loginLogoRelativePath;
  }

  public String getLoginLogoFileName() {
    return loginLogoFileName;
  }

  public void setLoginLogoFileName(String loginLogoFileName) {
    this.loginLogoFileName = loginLogoFileName;
  }

  public String getAppCode() {
    return appCode;
  }

  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }
}
