package com.bizunited.empower.business.tenant.vo;

import com.bizunited.empower.business.tenant.common.enums.TenantSettingSwitchEnum;
import com.bizunited.platform.common.vo.TenantVo;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

/**
 * 经销商租户设置Vo
 * @author Keller
 */
public class TenantSettingVo extends TenantVo {
  /**
   * 
   */
  private static final long serialVersionUID = 1695966018580725724L;

  @ApiModelProperty("仓库状态")
  private Boolean warehouseStatus;

  // ---支付设置------------------------------------------------------------------------------------------------------------

  @ApiModelProperty("现金支付状态")
  private Boolean cashPayStatus;

  @ApiModelProperty("订单部分付款状态")
  private Boolean orderPartialPayStatus;

  @ApiModelProperty("先货后款状态")
  private Boolean goodsBeforePayStatus;

  @ApiModelProperty("账期类型状态")
  private Boolean accountPeriodTypeStatus;

  @ApiModelProperty("信用支付状态")
  private Boolean creditBillStatus;

  // ---订单设置------------------------------------------------------------------------------------------------------------
  /**
   * 订单审核节点信息配置：目前包含节点名、节点上角色编码配置组合、节点所处顺序
   * 该值是一个JSONArray结构
   * 例如：[
   *        {"node":"name1","roleCodes":["YEWUYUAN1","CAIWU1"],"sorts":1},
   *        {"node":"name3","roleCodes":["YEWUYUAN3","CAIWU3"],"sorts":3},
   *        {"node":"name2","roleCodes":["YEWUYUAN2","CAIWU2"],"sorts":2}
   *      ]
   * */
  @ApiModelProperty("订单审核节点信息配置")
  private String auditNodeSettings;

  /**
   * 退货单审核节点信息配置：目前包含节点名、节点上角色编码配置组合、节点所处顺序
   * 该值是一个JSONArray结构：注意目前退货单只有一个审核节点
   * 例如：[
   *        {"node":"name1","roleCodes":["YEWUYUAN1","CAIWU1"],"sorts":1},
   *        {"node":"name3","roleCodes":["YEWUYUAN3","CAIWU3"],"sorts":3},
   *        {"node":"name2","roleCodes":["YEWUYUAN2","CAIWU2"],"sorts":2}
   *      ]
   * */
  @ApiModelProperty("退货单审核节点信息配置")
  private String returnAuditNodeSettings;

  @ApiModelProperty("订单必填收货地址状态")
  private Boolean orderRequiredReceiptAddressStatus;

  @ApiModelProperty("订单必填收货地址的业务类型由位运算‘|’求得的值，业务类型二进制值编号参考枚举：OrderBusinessNumber")
  private Integer orderRequiredReceiptAddressValue;

  @ApiModelProperty("订单必填交货日期状态")
  private Boolean orderRequiredDeliveryDateStatus;

  @ApiModelProperty("订单必填交货日期的业务类型由位运算‘|’求得的值，业务类型二进制值编号参考枚举：OrderBusinessNumber")
  private Integer orderRequiredDeliveryDateValue;

  @ApiModelProperty("客户取消订单")
  private Boolean customerCancelOrderStatus;

  @ApiModelProperty("最低下单金额状态")
  private Boolean minimumOrderAmountStatus;

  @ApiModelProperty("最低下单金额")
  private BigDecimal minimumOrderAmount;

  @ApiModelProperty("下单时间状态")
  private Boolean orderTimeStatus;

  @ApiModelProperty("下单时间")
  private Date orderTime;

  @ApiModelProperty("客户超时未收货，系统自动收货 状态")
  private Boolean automaticReceiptStatus;

  @ApiModelProperty("客户超时未收货，系统自动收货 值")
  private Integer automaticReceiptValue;

  @ApiModelProperty("自动取消订单 状态")
  private Boolean automaticCancelOrderStatus;

  @ApiModelProperty("自动取消订单 值, 单位 小时")
  private Integer automaticCancelOrderValue;

  @ApiModelProperty("禁止客户修改收货地址 状态")
  private Boolean banModifyReceiptAddressStatus;

  @ApiModelProperty("退货限制 状态")
  private Boolean returnLimitStatus;

  @ApiModelProperty("退货限制值,单位天")
  private Integer returnLimitValue;

  // ---库存设置------------------------------------------------------------------------------------------------------------
  @ApiModelProperty("商品库存占用 状态")
  private Boolean warehouseOccupyStatus;

  @ApiModelProperty("是否多仓库")
  private Boolean multipleWarehouses;

  @ApiModelProperty("负库存订货 状态")
  private Boolean negativeWarehouseStatus;

  @ApiModelProperty("客户订货端的库存显示 ——【大于】——选项")
  private Integer warehouseGtDisplayOption;

  @ApiModelProperty("客户订货端的库存显示 ——【大于】——自定义文本")
  private String warehouseGtDisplayText;

  @ApiModelProperty("客户订货端的库存显示 ——【大于】——阈值")
  private Integer warehouseGtDisplayThreshold;

  @ApiModelProperty("客户订货端的库存显示 ——【小于等于】——选项")
  private Integer warehouseLeDisplayOption;

  @ApiModelProperty("客户订货端的库存显示 ——【小于等于】——自定义文本")
  private String warehouseLeDisplayText;

  @ApiModelProperty("客户订货端的库存显示 ——【小于等于】——阈值")
  private Integer warehouseLeDisplayThreshold;

  @ApiModelProperty("超库存出库 状态 (是否强库存管控,强库存管控情况下不允许实际库存为负) 默认强库存 true")
  private Boolean overflowWarehouseStatus;

  // ---客户拜访设置------------------------------------------------------------------------------------------------------------
  @ApiModelProperty("签到、离店距离 状态")
  private Boolean distanceStatus;

  @ApiModelProperty("签到、离店距离——阈值，单位米")
  private Integer distanceThreshold;

  @ApiModelProperty("租户信息")
  private String tenantCode;

  // 展示相关设置---------------------------------------------------------------------------------------------------------------
  @ApiModelProperty("商品图片失效时展示的默认图片相对路径")
  private String productImgRelativePath;

  @ApiModelProperty("商品图片失效时展示的默认图片文件名")
  private String productImgFileName;

  // 开放商城设置--开放性功能设置
  /** 租户功能设置开关的全局聚合（此方式是将数据转换为二进制格式并对其对应位赋值（0：关闭，1：开启）以表示对应配置是否开启，包含的设置信息详情见：TenantConfigSwitchEnum）  */
  @ApiModelProperty("租户功能设置开关的全局聚合")
  private Long baseSettingSwitch;

  @ApiModelProperty("客户注册订货平台以后-未通过审核前浏览商品的规则（0：不允许浏览，1：商品金额展示未0，2：商品金额展示为空，3：商品金额展示原始订货价）")
  private Integer unreviewedCustomerBrowseProduct;

  @ApiModelProperty("游客（客户未登录前）访问订货平台浏览商品的规则（0：不允许浏览，1：商品金额展示未0，2：商品金额展示为空，3：商品金额展示原始订货价）")
  private Integer touristBrowseProduct;


  @ApiModelProperty("租户功能设置开关枚举列表")
  private Map<TenantSettingSwitchEnum, Integer> baseSettingSwitchMap;

  public Boolean getWarehouseStatus() {
    return warehouseStatus;
  }

  public void setWarehouseStatus(Boolean warehouseStatus) {
    this.warehouseStatus = warehouseStatus;
  }

  public Boolean getCashPayStatus() {
    return cashPayStatus;
  }

  public void setCashPayStatus(Boolean cashPayStatus) {
    this.cashPayStatus = cashPayStatus;
  }

  public Boolean getOrderPartialPayStatus() {
    return orderPartialPayStatus;
  }

  public void setOrderPartialPayStatus(Boolean orderPartialPayStatus) {
    this.orderPartialPayStatus = orderPartialPayStatus;
  }

  public Boolean getGoodsBeforePayStatus() {
    return goodsBeforePayStatus;
  }

  public void setGoodsBeforePayStatus(Boolean goodsBeforePayStatus) {
    this.goodsBeforePayStatus = goodsBeforePayStatus;
  }

  public Boolean getAccountPeriodTypeStatus() {
    return accountPeriodTypeStatus;
  }

  public void setAccountPeriodTypeStatus(Boolean accountPeriodTypeStatus) {
    this.accountPeriodTypeStatus = accountPeriodTypeStatus;
  }

  public Boolean getCreditBillStatus() {
    return creditBillStatus;
  }

  public void setCreditBillStatus(Boolean creditBillStatus) {
    this.creditBillStatus = creditBillStatus;
  }

  public String getAuditNodeSettings() {
    return auditNodeSettings;
  }

  public void setAuditNodeSettings(String auditNodeSettings) {
    this.auditNodeSettings = auditNodeSettings;
  }

  public String getReturnAuditNodeSettings() {
    return returnAuditNodeSettings;
  }

  public void setReturnAuditNodeSettings(String returnAuditNodeSettings) {
    this.returnAuditNodeSettings = returnAuditNodeSettings;
  }

  public Boolean getOrderRequiredReceiptAddressStatus() {
    return orderRequiredReceiptAddressStatus;
  }

  public void setOrderRequiredReceiptAddressStatus(Boolean orderRequiredReceiptAddressStatus) {
    this.orderRequiredReceiptAddressStatus = orderRequiredReceiptAddressStatus;
  }

  public Integer getOrderRequiredReceiptAddressValue() {
    return orderRequiredReceiptAddressValue;
  }

  public void setOrderRequiredReceiptAddressValue(Integer orderRequiredReceiptAddressValue) {
    this.orderRequiredReceiptAddressValue = orderRequiredReceiptAddressValue;
  }

  public Boolean getOrderRequiredDeliveryDateStatus() {
    return orderRequiredDeliveryDateStatus;
  }

  public void setOrderRequiredDeliveryDateStatus(Boolean orderRequiredDeliveryDateStatus) {
    this.orderRequiredDeliveryDateStatus = orderRequiredDeliveryDateStatus;
  }

  public Integer getOrderRequiredDeliveryDateValue() {
    return orderRequiredDeliveryDateValue;
  }

  public void setOrderRequiredDeliveryDateValue(Integer orderRequiredDeliveryDateValue) {
    this.orderRequiredDeliveryDateValue = orderRequiredDeliveryDateValue;
  }

  public Boolean getCustomerCancelOrderStatus() {
    return customerCancelOrderStatus;
  }

  public void setCustomerCancelOrderStatus(Boolean customerCancelOrderStatus) {
    this.customerCancelOrderStatus = customerCancelOrderStatus;
  }

  public Boolean getMinimumOrderAmountStatus() {
    return minimumOrderAmountStatus;
  }

  public void setMinimumOrderAmountStatus(Boolean minimumOrderAmountStatus) {
    this.minimumOrderAmountStatus = minimumOrderAmountStatus;
  }

  public BigDecimal getMinimumOrderAmount() {
    return minimumOrderAmount;
  }

  public void setMinimumOrderAmount(BigDecimal minimumOrderAmount) {
    this.minimumOrderAmount = minimumOrderAmount;
  }

  public Boolean getOrderTimeStatus() {
    return orderTimeStatus;
  }

  public void setOrderTimeStatus(Boolean orderTimeStatus) {
    this.orderTimeStatus = orderTimeStatus;
  }

  public Date getOrderTime() {
    return orderTime;
  }

  public void setOrderTime(Date orderTime) {
    this.orderTime = orderTime;
  }

  public Boolean getAutomaticReceiptStatus() {
    return automaticReceiptStatus;
  }

  public void setAutomaticReceiptStatus(Boolean automaticReceiptStatus) {
    this.automaticReceiptStatus = automaticReceiptStatus;
  }

  public Integer getAutomaticReceiptValue() {
    return automaticReceiptValue;
  }

  public void setAutomaticReceiptValue(Integer automaticReceiptValue) {
    this.automaticReceiptValue = automaticReceiptValue;
  }

  public Boolean getAutomaticCancelOrderStatus() {
    return automaticCancelOrderStatus;
  }

  public void setAutomaticCancelOrderStatus(Boolean automaticCancelOrderStatus) {
    this.automaticCancelOrderStatus = automaticCancelOrderStatus;
  }

  public Integer getAutomaticCancelOrderValue() {
    return automaticCancelOrderValue;
  }

  public void setAutomaticCancelOrderValue(Integer automaticCancelOrderValue) {
    this.automaticCancelOrderValue = automaticCancelOrderValue;
  }

  public Boolean getBanModifyReceiptAddressStatus() {
    return banModifyReceiptAddressStatus;
  }

  public void setBanModifyReceiptAddressStatus(Boolean banModifyReceiptAddressStatus) {
    this.banModifyReceiptAddressStatus = banModifyReceiptAddressStatus;
  }

  public Boolean getReturnLimitStatus() {
    return returnLimitStatus;
  }

  public void setReturnLimitStatus(Boolean returnLimitStatus) {
    this.returnLimitStatus = returnLimitStatus;
  }

  public Integer getReturnLimitValue() {
    return returnLimitValue;
  }

  public void setReturnLimitValue(Integer returnLimitValue) {
    this.returnLimitValue = returnLimitValue;
  }

  public Boolean getWarehouseOccupyStatus() {
    return warehouseOccupyStatus;
  }

  public void setWarehouseOccupyStatus(Boolean warehouseOccupyStatus) {
    this.warehouseOccupyStatus = warehouseOccupyStatus;
  }

  public Boolean getNegativeWarehouseStatus() {
    return negativeWarehouseStatus;
  }

  public void setNegativeWarehouseStatus(Boolean negativeWarehouseStatus) {
    this.negativeWarehouseStatus = negativeWarehouseStatus;
  }

  public Integer getWarehouseGtDisplayOption() {
    return warehouseGtDisplayOption;
  }

  public void setWarehouseGtDisplayOption(Integer warehouseGtDisplayOption) {
    this.warehouseGtDisplayOption = warehouseGtDisplayOption;
  }

  public String getWarehouseGtDisplayText() {
    return warehouseGtDisplayText;
  }

  public void setWarehouseGtDisplayText(String warehouseGtDisplayText) {
    this.warehouseGtDisplayText = warehouseGtDisplayText;
  }

  public Integer getWarehouseGtDisplayThreshold() {
    return warehouseGtDisplayThreshold;
  }

  public void setWarehouseGtDisplayThreshold(Integer warehouseGtDisplayThreshold) {
    this.warehouseGtDisplayThreshold = warehouseGtDisplayThreshold;
  }

  public Integer getWarehouseLeDisplayOption() {
    return warehouseLeDisplayOption;
  }

  public void setWarehouseLeDisplayOption(Integer warehouseLeDisplayOption) {
    this.warehouseLeDisplayOption = warehouseLeDisplayOption;
  }

  public String getWarehouseLeDisplayText() {
    return warehouseLeDisplayText;
  }

  public void setWarehouseLeDisplayText(String warehouseLeDisplayText) {
    this.warehouseLeDisplayText = warehouseLeDisplayText;
  }

  public Integer getWarehouseLeDisplayThreshold() {
    return warehouseLeDisplayThreshold;
  }

  public void setWarehouseLeDisplayThreshold(Integer warehouseLeDisplayThreshold) {
    this.warehouseLeDisplayThreshold = warehouseLeDisplayThreshold;
  }

  public Boolean getOverflowWarehouseStatus() {
    return overflowWarehouseStatus;
  }

  public void setOverflowWarehouseStatus(Boolean overflowWarehouseStatus) {
    this.overflowWarehouseStatus = overflowWarehouseStatus;
  }

  public Boolean getDistanceStatus() {
    return distanceStatus;
  }

  public void setDistanceStatus(Boolean distanceStatus) {
    this.distanceStatus = distanceStatus;
  }

  public Integer getDistanceThreshold() {
    return distanceThreshold;
  }

  public void setDistanceThreshold(Integer distanceThreshold) {
    this.distanceThreshold = distanceThreshold;
  }

  @Override
  public String getTenantCode() {
    return tenantCode;
  }

  @Override
  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getProductImgRelativePath() {
    return productImgRelativePath;
  }

  public void setProductImgRelativePath(String productImgRelativePath) {
    this.productImgRelativePath = productImgRelativePath;
  }

  public String getProductImgFileName() {
    return productImgFileName;
  }

  public void setProductImgFileName(String productImgFileName) {
    this.productImgFileName = productImgFileName;
  }

  public Long getBaseSettingSwitch() {
    return baseSettingSwitch;
  }

  public void setBaseSettingSwitch(Long baseSettingSwitch) {
    this.baseSettingSwitch = baseSettingSwitch;
  }

  public Integer getUnreviewedCustomerBrowseProduct() {
    return unreviewedCustomerBrowseProduct;
  }

  public void setUnreviewedCustomerBrowseProduct(Integer unreviewedCustomerBrowseProduct) {
    this.unreviewedCustomerBrowseProduct = unreviewedCustomerBrowseProduct;
  }

  public Integer getTouristBrowseProduct() {
    return touristBrowseProduct;
  }

  public void setTouristBrowseProduct(Integer touristBrowseProduct) {
    this.touristBrowseProduct = touristBrowseProduct;
  }

  public Map<TenantSettingSwitchEnum, Integer> getBaseSettingSwitchMap() {
    return baseSettingSwitchMap;
  }

  public void setBaseSettingSwitchMap(Map<TenantSettingSwitchEnum, Integer> baseSettingSwitchMap) {
    this.baseSettingSwitchMap = baseSettingSwitchMap;
  }

  public Boolean getMultipleWarehouses() {
    return multipleWarehouses;
  }

  public void setMultipleWarehouses(Boolean multipleWarehouses) {
    this.multipleWarehouses = multipleWarehouses;
  }
}
