package com.bizunited.empower.business.vehicle.constant;

/**
 * 车辆模块涉及的redis key
 */
public class VehicleRedisKey {
  private VehicleRedisKey(){}


  /** 车辆编码key */
  public static final String VEHICLE_CODE_AUTO_INC_KEY = "vehicle:code:index:%s";

  /**
   * 锁定车辆仓库redis锁
   * 第一个参数：经销商编码
   * 第二个参数：车辆编码
   */
  public final static String LOCK_VEHICLE_STOCK_CODE_PREFIX = "lock:vehicle:stock:%s:%s";

  /** 车辆装货单编码key */
  public static final String VEHICLE_LOAD_CODE_AUTO_INC_KEY = "vehicle:load:code:index:%s";

  /** 车辆卸货单编码key */
  public static final String VEHICLE_UNLOAD_CODE_AUTO_INC_KEY = "vehicle:unload:code:index:%s";
}
