package com.bizunited.empower.business.vehicle.controller;

import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.empower.business.vehicle.service.VehicleService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Vehicle业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@Api(tags = "车辆管理控制器")
@RequestMapping("/v1/vehicle")
public class VehicleController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(VehicleController.class);
  
  @Autowired
  private VehicleService vehicleService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建vehicle中的基本信息以外，还可以对vehicle中属于OneToMany关联的明细信息一同进行创建注意：基于（Vehicle）模型的创建操作传入的vehicleJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建vehicle中的基本信息以外，还可以对vehicle中属于OneToMany关联的明细信息一同进行创建注意：基于（Vehicle）模型的创建操作传入的vehicleJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="vehicle" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建vehicle中的基本信息以外，还可以对vehicle中属于OneToMany关联的明细信息一同进行创建注意：基于（Vehicle）模型的创建操作传入的vehicleJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") Vehicle vehicle) {
    try {
      Vehicle current = this.vehicleService.create(vehicle);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（Vehicle）的修改操作传入的vehicleJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（Vehicle）的修改操作传入的vehicleJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="vehicle" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（Vehicle）的修改操作传入的vehicleJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") Vehicle vehicle) {
    try {
      Vehicle current = this.vehicleService.update(vehicle);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value="/{id}")
  public ResponseModel findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      Vehicle current = this.vehicleService.findById(id);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @DeleteMapping(value="/{id}")
  public ResponseModel deleteById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      this.vehicleService.deleteById(id);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照Vehicle实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照Vehicle实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      Vehicle result = this.vehicleService.findDetailsById(id); 
      return this.buildHttpResultW(result, new String[]{}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }

  /**
   * 分页查询
   * @param pageable
   * @param carNumber 车牌号
   * @param vehicleStatus 车辆状态
   * @return
   */
  @GetMapping("findByConditions")
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findByConditions(@PageableDefault(50) Pageable pageable,
                                        @RequestParam(required = false) @ApiParam("车牌号") String carNumber,
                                        @RequestParam(required = false) @ApiParam("车辆名称") String vehicleName,
                                        @RequestParam(required = false) @ApiParam("状态") Integer vehicleStatus
  ) {
    try {
      Map<String, Object> conditions = new HashMap<>();
      conditions.put("carNumber", carNumber);
      conditions.put("vehicleName", vehicleName);
      conditions.put("vehicleStatus", vehicleStatus);
      Page<Vehicle> vehicles = this.vehicleService.findByConditions(pageable, conditions);
      return this.buildHttpResultW(vehicles);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据车辆编码修改车辆状态
   * @param vehicleCode
   * @param vehicleStatus
   */
  @PostMapping("updateVehicleStatus")
  @ApiOperation(value = "根据车辆编码修改车辆状态")
  public ResponseModel updateVehicleStatus(@RequestParam("vehicleCode") String vehicleCode,@RequestParam("vehicleStatus") Integer vehicleStatus) {
    try {
      vehicleService.updateVehicleStatus(vehicleCode,vehicleStatus);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 查询租户下全部已启用车辆集合
   */
  @GetMapping("findAll")
  @ApiOperation(value = "查询租户下全部车辆集合")
  public ResponseModel findAll() {
    try {
      List<Vehicle> all = vehicleService.findAll();
      return this.buildHttpResultW(all);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据业务员账号查询关联车辆
   */
  @GetMapping("findByUserAccount")
  @ApiOperation(value = "根据业务员账号查询关联车辆")
  public ResponseModel findByUserAccount(@RequestParam("userAccount")String userAccount) {
    try {
      List<Vehicle> all = vehicleService.findByUserAccount(userAccount);
      return this.buildHttpResultW(all);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据车辆编码删除车辆
   * @param vehicleCode
   */
  @PostMapping("deleteVehicle")
  @ApiOperation(value = "根据车辆编码删除车辆")
  public ResponseModel deleteVehicle(@RequestParam("vehicleCode") String vehicleCode) {
    try {
      vehicleService.deleteVehicle(vehicleCode);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
} 
