package com.bizunited.empower.business.vehicle.controller;

import com.bizunited.empower.business.vehicle.dto.VehicleProductStockDto;
import com.bizunited.empower.business.vehicle.service.VehicleProductStockVoService;
import com.bizunited.empower.business.vehicle.vo.VehicleProductStockVo;
import com.bizunited.empower.business.vehicle.vo.VehicleStockQuantityVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Vehicle业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/vehicleProductStockVo")
public class VehicleProductStockVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(VehicleProductStockVoController.class);
  
  @Autowired
  private VehicleProductStockVoService vehicleProductStockVoService;


  /**
   * 根据车辆编码查询车辆库存数据
   * @param vehicleCode
   * @return
   */
  @GetMapping("findStockByVehicleCode")
  @ApiOperation(value = "根据车辆编码查询车辆库存数据")
  public ResponseModel deliverGoods(@RequestParam("vehicleCode") String vehicleCode) {
    try {
      VehicleStockQuantityVo vehicleStockQuantityVo = vehicleProductStockVoService.findStockByVehicleCode(vehicleCode);
      return this.buildHttpResultW(vehicleStockQuantityVo);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 分页查询
   * @param pageable
   * @return
   */
  @GetMapping("findByConditions")
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findByConditions(@PageableDefault(50) Pageable pageable,@ApiParam(name = "dto", value = "查询条件dto结构体") VehicleProductStockDto dto
  ) {
    try {
      Page<VehicleProductStockVo> vehicleReturnVos = this.vehicleProductStockVoService.findByConditions(pageable, dto);
      return this.buildHttpResultW(vehicleReturnVos);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 分页查询(根据商品分组聚合库存)
   * @param pageable
   * @return
   */
  @GetMapping("findProductByConditions")
  @ApiOperation(value = "多条件分页查询(根据商品分组聚合库存)", notes = "分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findProductByConditions(@PageableDefault(50) Pageable pageable,@ApiParam(name = "dto", value = "查询条件dto结构体") VehicleProductStockDto dto
  ) {
    try {
      Page<VehicleProductStockVo> vehicleReturnVos = this.vehicleProductStockVoService.findProductByConditions(pageable, dto);
      return this.buildHttpResultW(vehicleReturnVos);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
} 
