package com.bizunited.empower.business.vehicle.dto;

/**
 * @Author: wjx
 * @Date: 2021/4/21 16:23
 */

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "VehicleProductStockDto", description = "库存数据查询Dto")
public class VehicleProductStockDto {
  @ApiModelProperty("租户编码")
  private String tenantCode;

  @ApiModelProperty("车辆编码")
  private String vehicleCode;

  @ApiModelProperty("商品名称")
  private String productName;

  @ApiModelProperty("品牌编码")
  private String brandCode;

  @ApiModelProperty("分类编码")
  private String categoryCode;

  @ApiModelProperty("车载商品类型 1配送商品 2车销商品 3不可售商品")
  private Integer vehicleProductType;

  @ApiModelProperty("出车任务编码")
  private String vehicleTaskCode;

  @ApiModelProperty("是否要求库存必须大于0")
  private Boolean stock;

  /**
   * 展示可转化为某类型商品的商品
   * 例如 标记为不可售 展示 类型为车销的 商品
   * 标记为车销 展示 类型为不可售的 商品
   */
  @ApiModelProperty("标记为的商品里类型 1配送商品 2车销商品 3不可售商品")
  private Integer signType;

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getVehicleCode() {
    return vehicleCode;
  }

  public void setVehicleCode(String vehicleCode) {
    this.vehicleCode = vehicleCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public String getCategoryCode() {
    return categoryCode;
  }

  public void setCategoryCode(String categoryCode) {
    this.categoryCode = categoryCode;
  }

  public Integer getVehicleProductType() {
    return vehicleProductType;
  }

  public void setVehicleProductType(Integer vehicleProductType) {
    this.vehicleProductType = vehicleProductType;
  }

  public String getVehicleTaskCode() {
    return vehicleTaskCode;
  }

  public void setVehicleTaskCode(String vehicleTaskCode) {
    this.vehicleTaskCode = vehicleTaskCode;
  }

  public Boolean getStock() {
    return stock;
  }

  public void setStock(Boolean stock) {
    this.stock = stock;
  }

  public Integer getSignType() {
    return signType;
  }

  public void setSignType(Integer signType) {
    this.signType = signType;
  }
}
