package com.bizunited.empower.business.vehicle.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

/**
 * @Author: wjx
 * @Date: 2021/3/29 16:12
 */
@ApiModel(value = "Vehicle", description = "车辆信息")
@Entity
@Table(name = "vehicle" , indexes = @Index(columnList = "tenant_code,vehicle_code "))
@org.hibernate.annotations.Table(appliesTo = "vehicle", comment = "车辆信息")
@BuildCustomRepository
public class Vehicle extends TenantOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -4318774744386109114L;

  /**
   * 车辆编码
   */
  @Column(name = "vehicle_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 车辆编码 '")
  @SaturnColumn(description = "车辆编码")
  @ApiModelProperty("车辆编码")
  private String vehicleCode;

  /**
   * 车辆名称
   */
  @Column(name = "vehicle_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 车辆名称 '")
  @SaturnColumn(description = "车辆名称")
  @ApiModelProperty("车辆名称")
  private String vehicleName;

  /**
   * 车牌号
   */
  @Column(name = "car_number", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 车牌号 '")
  @SaturnColumn(description = "车牌号")
  @ApiModelProperty("车牌号")
  private String carNumber;

  /**
   * 车辆状态 具体枚举见：com.bizunited.empower.business.vehicle.enums.VehicleStatusEnum
   */
  @Column(name = "vehicle_status", nullable = false, columnDefinition = "INT COMMENT ' 车辆状态 1启用 2禁用 '")
  @SaturnColumn(description = "车辆状态 1启用 2禁用")
  @ApiModelProperty("车辆状态 1启用 2禁用")
  private Integer vehicleStatus;

  /**
   * 车辆类型 具体枚举见：com.bizunited.empower.business.vehicle.enums.VehicleTypeEnum
   */
  @Column(name = "vehicle_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 车辆类型 1微型货车 2轻型货车 3中型货车 4重型货车'")
  @SaturnColumn(description = "车辆类型 1微型货车 2轻型货车 3中型货车 4重型货车")
  @ApiModelProperty("车辆类型 1微型货车 2轻型货车 3中型货车 4重型货车")
  private Integer vehicleType;

  /**
   * 动力类型 具体枚举见：com.bizunited.empower.business.vehicle.enums.PowerTypeEnum
   */
  @Column(name = "power_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 动力类型 1汽油 2柴油 3纯电动 4油电混合'")
  @SaturnColumn(description = "动力类型 1汽油 2柴油 3纯电动 4油电混合")
  @ApiModelProperty("动力类型 1汽油 2柴油 3纯电动 4油电混合")
  private String powerType;

  /**
   * 是否冷链
   */
  @Column(name = "is_cold_chain", nullable = false,columnDefinition = "tinyint(1) COMMENT ' 是否冷链 '")
  @SaturnColumn(description = "是否冷链")
  @ApiModelProperty("是否冷链")
  private Boolean coldChain;

  //货车参数

  /**
   * 总重量
   */
  @Column(name = "weight", nullable = true, precision = 10, scale = 2, columnDefinition = "DECIMAL(10,2) COMMENT '总重量'")
  @SaturnColumn(description = "总重量")
  @ApiModelProperty("总重量")
  private Double weight;

  /**
   * 核定重量
   */
  @Column(name = "approved_weight", nullable = true, precision = 10, scale = 2, columnDefinition = "DECIMAL(10,2) COMMENT '核定重量'")
  @SaturnColumn(description = "核定重量")
  @ApiModelProperty("核定重量")
  private Double approvedWeight;

  /**
   * 车长
   */
  @Column(name = "length", nullable = true, precision = 10, scale = 2, columnDefinition = "DECIMAL(10,2) COMMENT '车长'")
  @SaturnColumn(description = "车长")
  @ApiModelProperty("车长")
  private Double length;

  /**
   * 车宽
   */
  @Column(name = "wide", nullable = true, precision = 10, scale = 2, columnDefinition = "DECIMAL(10,2) COMMENT '车宽'")
  @SaturnColumn(description = "车宽")
  @ApiModelProperty("车宽")
  private Double wide;

  /**
   * 车高
   */
  @Column(name = "high", nullable = true, precision = 10, scale = 2, columnDefinition = "DECIMAL(10,2) COMMENT '车高'")
  @SaturnColumn(description = "车高")
  @ApiModelProperty("车高")
  private Double high;

  /**
   * 轴数 具体枚举见：com.bizunited.empower.business.vehicle.enums.AxesQuantityEnum
   */
  @Column(name = "axes_quantity", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 轴数 1,1轴 2,2轴 3,3轴 4,4轴 5,5轴 6,6轴 7,6轴以上 '")
  @SaturnColumn(description = "轴数 1,1轴 2,2轴 3,3轴 4,4轴 5,5轴 6,6轴 7,6轴以上")
  @ApiModelProperty("轴数 1,1轴 2,2轴 3,3轴 4,4轴 5,5轴 6,6轴 7,6轴以上")
  private String axesQuantity;

  /**
   * 排放标准 具体枚举见：com.bizunited.empower.business.vehicle.enums.EmissionStandardEnum
   */
  @Column(name = "emission_standard", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 排放标准 1国一 2国二 3国三 4国四 5国五 6国六 '")
  @SaturnColumn(description = "排放标准 1国一 2国二 3国三 4国四 5国五 6国六")
  @ApiModelProperty("排放标准 1国一 2国二 3国三 4国四 5国五 6国六")
  private String emissionStandard;

  /**
   * 车牌颜色 具体枚举见：com.bizunited.empower.business.vehicle.enums.LicenseColorEnum
   */
  @Column(name = "license_color", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 车牌颜色 1蓝牌 2红牌 3绿牌 4黑牌 '")
  @SaturnColumn(description = "车牌颜色 1蓝牌 2红牌 3绿牌 4黑牌")
  @ApiModelProperty("车牌颜色 1蓝牌 2红牌 3绿牌 4黑牌")
  private String licenseColor;

  /**
   * 货车用途 具体枚举见：com.bizunited.empower.business.vehicle.enums.PurposeEnum
   */
  @Column(name = "purpose", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 货车用途 1拖挂 '")
  @SaturnColumn(description = "货车用途 1拖挂")
  @ApiModelProperty("货车用途 1拖挂")
  private String purpose;

  /**
   * 备注
   */
  @Column(name = "remark", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 备注 '")
  @SaturnColumn(description = "备注")
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 车辆运输状态 具体枚举见：com.bizunited.empower.business.vehicle.enums.VehicleTransportStatusEnum
   */
  @Column(name = "vehicle_transport_status", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 车辆运输状态 1空置 2占用 3维修'")
  @SaturnColumn(description = "车辆运输状态 1空置 2占用 3维修")
  @ApiModelProperty("车辆运输状态 1空置 2占用 3维修")
  private Integer vehicleTransportStatus;

  /**
   * 车辆库存
   */
  @SaturnColumn(description="车辆库存")
  @ApiModelProperty("车辆库存")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "vehicle")
  private Set<VehicleProductStock> vehicleProductStocks;

  /**
   * 删除标识  true:已删除，false：未删除
   */
  @ApiModelProperty(name = "isDelete", value = "删除标识", required = false)
  @SaturnColumn(description = "删除标识")
  @Column(name = "is_delete", nullable = false, columnDefinition = "bit(1) default 0 comment '删除标识'")
  private Boolean delete = false;


  public String getVehicleCode() {
    return vehicleCode;
  }

  public void setVehicleCode(String vehicleCode) {
    this.vehicleCode = vehicleCode;
  }

  public String getVehicleName() {
    return vehicleName;
  }

  public void setVehicleName(String vehicleName) {
    this.vehicleName = vehicleName;
  }

  public String getCarNumber() {
    return carNumber;
  }

  public void setCarNumber(String carNumber) {
    this.carNumber = carNumber;
  }

  public Integer getVehicleStatus() {
    return vehicleStatus;
  }

  public void setVehicleStatus(Integer vehicleStatus) {
    this.vehicleStatus = vehicleStatus;
  }

  public Integer getVehicleType() {
    return vehicleType;
  }

  public void setVehicleType(Integer vehicleType) {
    this.vehicleType = vehicleType;
  }

  public String getPowerType() {
    return powerType;
  }

  public void setPowerType(String powerType) {
    this.powerType = powerType;
  }

  public Boolean getColdChain() {
    return coldChain;
  }

  public void setColdChain(Boolean coldChain) {
    this.coldChain = coldChain;
  }

  public Double getWeight() {
    return weight;
  }

  public void setWeight(Double weight) {
    this.weight = weight;
  }

  public Double getApprovedWeight() {
    return approvedWeight;
  }

  public void setApprovedWeight(Double approvedWeight) {
    this.approvedWeight = approvedWeight;
  }

  public Double getLength() {
    return length;
  }

  public void setLength(Double length) {
    this.length = length;
  }

  public Double getWide() {
    return wide;
  }

  public void setWide(Double wide) {
    this.wide = wide;
  }

  public Double getHigh() {
    return high;
  }

  public void setHigh(Double high) {
    this.high = high;
  }

  public String getAxesQuantity() {
    return axesQuantity;
  }

  public void setAxesQuantity(String axesQuantity) {
    this.axesQuantity = axesQuantity;
  }

  public String getEmissionStandard() {
    return emissionStandard;
  }

  public void setEmissionStandard(String emissionStandard) {
    this.emissionStandard = emissionStandard;
  }

  public String getLicenseColor() {
    return licenseColor;
  }

  public void setLicenseColor(String licenseColor) {
    this.licenseColor = licenseColor;
  }

  public String getPurpose() {
    return purpose;
  }

  public void setPurpose(String purpose) {
    this.purpose = purpose;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Integer getVehicleTransportStatus() {
    return vehicleTransportStatus;
  }

  public void setVehicleTransportStatus(Integer vehicleTransportStatus) {
    this.vehicleTransportStatus = vehicleTransportStatus;
  }

  public Set<VehicleProductStock> getVehicleProductStocks() {
    return vehicleProductStocks;
  }

  public void setVehicleProductStocks(Set<VehicleProductStock> vehicleProductStocks) {
    this.vehicleProductStocks = vehicleProductStocks;
  }

  public Boolean getDelete() {
    return delete;
  }

  public void setDelete(Boolean delete) {
    this.delete = delete;
  }
}
