package com.bizunited.empower.business.vehicle.entity;

import com.bizunited.platform.common.entity.TenantEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 卸货商品  出车任务 出车记录 收车退货公用
 * @Author: wjx
 * @Date: 2021/3/30 11:17
 */
@ApiModel(value = "VehicleLoadProduct", description = "装货商品")
@Entity
@Table(name = "`vehicle_load_product`" , indexes = @Index(columnList = "tenant_code,product_code "))
@org.hibernate.annotations.Table(appliesTo = "`vehicle_load_product`", comment = "装货商品")
@BuildCustomRepository
public class VehicleLoadProduct extends TenantEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 2289581666435069625L;

  /** 车辆装货入库单 */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name="vehicle_load_order_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT '车辆装货入库单'")
  @SaturnColumn(description = "车辆装货入库单")
  private VehicleLoad vehicleLoad;

  /**
   * 商品编码
   */
  @Column(name = "product_code", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品编码 '")
  @SaturnColumn(description = "商品编码")
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @Column(name = "product_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品名称 '")
  @SaturnColumn(description = "商品名称")
  @ApiModelProperty("商品名称")
  private String productName;

  /** 相对路径 */
  @Column(name = "relative_path", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 相对路径 '")
  @SaturnColumn(description = "相对路径")
  @ApiModelProperty("相对路径")
  private String relativePath;

  /** 文件名 */
  @Column(name = "file_name", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 文件名 '")
  @SaturnColumn(description = "文件名")
  @ApiModelProperty("文件名")
  private String fileName;

  /**
   * 规格编号
   */
  @Column(name = "product_specification_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 规格编号 '")
  @SaturnColumn(description = "规格编号")
  @ApiModelProperty("规格编号")
  private String productSpecificationCode;

  /**
   * 规格名称
   */
  @Column(name = "product_specification_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT ' 规格名称 '")
  @SaturnColumn(description = "规格名称")
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /**
   * 单位编号
   */
  @Column(name = "unit_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 单位编号 '")
  @SaturnColumn(description = "单位编号")
  @ApiModelProperty("单位编号")
  private String unitCode;

  /**
   * 单位名称
   */
  @Column(name = "unit_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 单位名称 '")
  @SaturnColumn(description = "单位名称")
  @ApiModelProperty("单位名称")
  private String unitName;

  /**
   * 条形码
   */
  @Column(name = "bar_code", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 条形码 '")
  @SaturnColumn(description = "条形码")
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 装货数量
   */
  @Column(name = "quantity", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT ' 装货数量 '")
  @SaturnColumn(description = "装货数量")
  @ApiModelProperty("装货数量")
  private BigDecimal quantity;

  /**
   * 参考采购价
   */
  @Column(name = "purchase_price", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 参考采购价 ，千位数代表.000'")
  @SaturnColumn(description = "参考采购价，千位数代表.000")
  @ApiModelProperty("参考采购价，千位数代表.000")
  private BigDecimal purchasePrice;

  /** 小计金额 (行商品总价)*/
  @Column(name = "subtotal_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 小计金额 ，千位数代表.000'")
  @SaturnColumn(description = "小计金额，千位数代表.000")
  @ApiModelProperty("小计金额，千位数代表.000")
  private BigDecimal subtotalAmount;

  public VehicleLoad getVehicleLoad() {
    return vehicleLoad;
  }

  public void setVehicleLoad(VehicleLoad vehicleLoad) {
    this.vehicleLoad = vehicleLoad;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public String getUnitName() {
    return unitName;
  }

  public void setUnitName(String unitName) {
    this.unitName = unitName;
  }

  public String getBarCode() {
    return barCode;
  }

  public void setBarCode(String barCode) {
    this.barCode = barCode;
  }

  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  public BigDecimal getPurchasePrice() {
    return purchasePrice;
  }

  public void setPurchasePrice(BigDecimal purchasePrice) {
    this.purchasePrice = purchasePrice;
  }

  public BigDecimal getSubtotalAmount() {
    return subtotalAmount;
  }

  public void setSubtotalAmount(BigDecimal subtotalAmount) {
    this.subtotalAmount = subtotalAmount;
  }
}
