package com.bizunited.empower.business.vehicle.entity;

import com.bizunited.platform.common.entity.TenantEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 车载商品类型转换记录
 * @Author: wjx
 * @Date: 2021/9/27 10:21
 */
@ApiModel(value = "VehicleProductTypeTransformRecord", description = "车载商品类型转换记录")
@Entity
@Table(name = "`vehicle_product_type_transform_record`" , indexes = @Index(columnList = "tenant_code,product_code "))
@org.hibernate.annotations.Table(appliesTo = "`vehicle_product_type_transform_record`", comment = "车载商品类型转换记录")
@BuildCustomRepository
public class VehicleProductTypeTransformRecord extends TenantEntity {

  /**
   * 出车任务编号
   */
  @Column(name = "vehicle_task_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出车任务编号 '")
  @SaturnColumn(description = "出车任务编号")
  @ApiModelProperty("出车任务编号")
  private String vehicleTaskCode;

  /**
   * 车辆编码
   */
  @Column(name = "vehicle_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 车辆编码 '")
  @SaturnColumn(description = "车辆编码")
  @ApiModelProperty("车辆编码")
  private String vehicleCode;

  /**
   * 转换前车载商品类型  具体枚举见:com.bizunited.empower.terminal.staff.enums.vehicle.VehicleProductTypeEnum
   */
  @Column(name = "before_vehicle_product_type", nullable = false, columnDefinition = "INT COMMENT ' 转换前车载商品类型 1配送商品 2车销商品 3不可售商品'")
  @SaturnColumn(description = "转换前车载商品类型 1配送商品 2车销商品 3不可售商品")
  @ApiModelProperty("转换前车载商品类型 1配送商品 2车销商品 3不可售商品")
  private Integer beforeVehicleProductType;

  /**
   * 转换后车载商品类型  具体枚举见:com.bizunited.empower.terminal.staff.enums.vehicle.VehicleProductTypeEnum
   */
  @Column(name = "after_vehicle_product_type", nullable = false, columnDefinition = "INT COMMENT ' 转换后车载商品类型 1配送商品 2车销商品 3不可售商品'")
  @SaturnColumn(description = "转换后车载商品类型 1配送商品 2车销商品 3不可售商品")
  @ApiModelProperty("转换后车载商品类型 1配送商品 2车销商品 3不可售商品")
  private Integer afterVehicleProductType;

  /** 单位编号 */
  @Column(name = "unit_code", length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 单位编号 '")
  @SaturnColumn(description = "单位编号")
  @ApiModelProperty("单位编号")
  private String unitCode;

  /** 单位名称 */
  @Column(name = "unit_name", length = 128,columnDefinition = "VARCHAR(128) COMMENT ' 单位名称 '")
  @SaturnColumn(description = "单位名称")
  @ApiModelProperty("单位名称")
  private String unitName;

  /**
   * 商品编码
   */
  @Column(name = "product_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  @SaturnColumn(description = "商品编码")
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @Column(name = "product_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品名称 '")
  @SaturnColumn(description = "商品名称")
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 品牌编码
   */
  @Column(name = "brand_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 品牌编码 '")
  @SaturnColumn(description = "品牌编码")
  @ApiModelProperty("品牌编码")
  private String brandCode;

  /**
   * 品牌名称
   */
  @Column(name = "brand_name", nullable = true, length = 64, columnDefinition = "VARCHAR(1024) COMMENT ' 品牌名称 '")
  @SaturnColumn(description = "品牌名称")
  @ApiModelProperty("品牌名称")
  private String brandName;

  /**
   * 分类名称
   */
  @Column(name = "category_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 分类名称 '")
  @SaturnColumn(description = "分类名称")
  @ApiModelProperty("分类名称")
  private String categoryName;

  /**
   * 分类编码
   */
  @Column(name = "category_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分类编码 '")
  @SaturnColumn(description = "分类编码")
  @ApiModelProperty("分类编码")
  private String categoryCode;

  /**
   * 规格编码
   */
  @Column(name = "product_specification_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 规格编码 '")
  @SaturnColumn(description = "规格编码")
  @ApiModelProperty("规格编码")
  private String productSpecificationCode;

  /**
   * 规格名称
   */
  @Column(name = "product_specification_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT ' 规格名称 '")
  @SaturnColumn(description = "规格名称")
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /** 相对路径 */
  @Column(name = "relative_path", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 相对路径 '")
  @SaturnColumn(description = "相对路径")
  @ApiModelProperty("相对路径")
  private String relativePath;

  /** 文件名 */
  @Column(name = "file_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件名 '")
  @SaturnColumn(description = "文件名")
  @ApiModelProperty("文件名")
  private String fileName;

  /**
   * 条形码
   */
  @Column(name = "bar_code", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 条形码 '")
  @SaturnColumn(description = "条形码")
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 转换数量
   */
  @Column(name = "quantity", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT ' 转换数量 '")
  @SaturnColumn(description = "转换数量（后三位是小数的转换）")
  @ApiModelProperty("转换数量（后三位是小数的转换）")
  private BigDecimal quantity;

  public String getVehicleTaskCode() {
    return vehicleTaskCode;
  }

  public void setVehicleTaskCode(String vehicleTaskCode) {
    this.vehicleTaskCode = vehicleTaskCode;
  }

  public String getVehicleCode() {
    return vehicleCode;
  }

  public void setVehicleCode(String vehicleCode) {
    this.vehicleCode = vehicleCode;
  }

  public Integer getBeforeVehicleProductType() {
    return beforeVehicleProductType;
  }

  public void setBeforeVehicleProductType(Integer beforeVehicleProductType) {
    this.beforeVehicleProductType = beforeVehicleProductType;
  }

  public Integer getAfterVehicleProductType() {
    return afterVehicleProductType;
  }

  public void setAfterVehicleProductType(Integer afterVehicleProductType) {
    this.afterVehicleProductType = afterVehicleProductType;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public String getUnitName() {
    return unitName;
  }

  public void setUnitName(String unitName) {
    this.unitName = unitName;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public String getBrandName() {
    return brandName;
  }

  public void setBrandName(String brandName) {
    this.brandName = brandName;
  }

  public String getCategoryName() {
    return categoryName;
  }

  public void setCategoryName(String categoryName) {
    this.categoryName = categoryName;
  }

  public String getCategoryCode() {
    return categoryCode;
  }

  public void setCategoryCode(String categoryCode) {
    this.categoryCode = categoryCode;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getBarCode() {
    return barCode;
  }

  public void setBarCode(String barCode) {
    this.barCode = barCode;
  }

  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }
}
