package com.bizunited.empower.business.vehicle.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * @Author: wjx
 * @Date: 2021/3/30 10:39
 */
@ApiModel(value = "VehicleUnload", description = "车辆卸货出库单")
@Entity
@Table(name = "`vehicle_unload`" , indexes = @Index(columnList = "tenant_code,vehicle_code "))
@org.hibernate.annotations.Table(appliesTo = "`vehicle_unload`", comment = "车辆卸货出库单")
@BuildCustomRepository
public class VehicleUnload extends TenantOpEntity {
  /**
   *
   */
  private static final long serialVersionUID = 3988538936870624242L;

  /**
   * 卸货单编号
   */
  @Column(name = "vehicle_unload_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 卸货单编号 '")
  @SaturnColumn(description = "卸货单编号")
  @ApiModelProperty("卸货单编号")
  private String vehicleUnloadCode;

  /**
   * 卸货类型 具体枚举见:com.bizunited.empower.terminal.staff.enums.vehicle.VehicleUnloadTypeEnum
   */
  @Column(name = "vehicle_unload_type", nullable = false, columnDefinition = "INT COMMENT ' 出货类型 1车销调拨 2销售订单 3收车退货'")
  @SaturnColumn(description = "出货类型 1车销调拨 2销售订单 3收车退货")
  @ApiModelProperty("出货类型 1车销调拨 2销售订单 3收车退货")
  private Integer vehicleUnloadType;

  /**
   * 车载商品类型  具体枚举见:com.bizunited.empower.terminal.staff.enums.vehicle.VehicleProductTypeEnum
   */
  @Column(name = "vehicle_product_type", nullable = false, columnDefinition = "INT COMMENT ' 车载商品类型 1配送商品 2车销商品'")
  @SaturnColumn(description = "车载商品类型")
  @ApiModelProperty("车载商品类型")
  private Integer vehicleProductType;

  /**
   * 卸货状态 具体枚举见:com.bizunited.empower.terminal.staff.enums.vehicle.VehicleUnloadStatusEnum
   */
  @Column(name = "vehicle_unload_status", nullable = false, columnDefinition = "INT COMMENT ' 1待交货 2已交货 3已取消'")
  @SaturnColumn(description = "1待交货 2已交货 3已取消")
  @ApiModelProperty("1待交货 2已交货 3已取消")
  private Integer vehicleUnloadStatus;

  /**
   * 关联订单编号
   */
  @Column(name = "relevance_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 关联订单编号 '")
  @SaturnColumn(description = "关联订单编号")
  @ApiModelProperty("关联订单编号")
  private String relevanceCode;

  /**
   * 出车任务编号
   */
  @Column(name = "vehicle_task_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出车任务编号 '")
  @SaturnColumn(description = "出车任务编号")
  @ApiModelProperty("出车任务编号")
  private String vehicleTaskCode;

  /**
   * 车辆编码
   */
  @Column(name = "vehicle_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 车辆编码 '")
  @SaturnColumn(description = "车辆编码")
  @ApiModelProperty("车辆编码")
  private String vehicleCode;

  /**
   * 车辆名称
   */
  @Column(name = "vehicle_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 车辆名称 '")
  @SaturnColumn(description = "车辆名称")
  @ApiModelProperty("车辆名称")
  private String vehicleName;

  /**
   * 业务员编号(账号)
   */
  @Column(name = "sale_man_account", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '业务员编号(账号)'")
  @SaturnColumn(description = "业务员编号(账号)")
  @ApiModelProperty("业务员编号(账号)")
  private String saleManAccount;

  /**
   * 业务员名称
   */
  @Column(name = "sale_man_name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '业务员名称'")
  @SaturnColumn(description = "业务员名称")
  @ApiModelProperty("业务员名称")
  private String saleManName;

  /**
   * 客户编码
   */
  @Column(name = "customer_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户code '")
  @SaturnColumn(description = "客户编码")
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @Column(name = "customer_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户名称 '")
  @SaturnColumn(description = "客户名称")
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 确认卸货时间
   */
  @Column(name = "vehicle_unload_time", nullable = true, columnDefinition = "datetime COMMENT ' 确认卸货时间 '")
  @SaturnColumn(description = "确认卸货时间")
  @ApiModelProperty("确认卸货时间")
  private Date vehicleUnloadTime;

  /**
   * 卸货商品集合
   */
  @SaturnColumn(description = "卸货商品集合")
  @ApiModelProperty("卸货商品集合")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "vehicleUnload")
  private Set<VehicleUnloadProduct> products;

  public Integer getVehicleUnloadType() {
    return vehicleUnloadType;
  }

  public void setVehicleUnloadType(Integer vehicleUnloadType) {
    this.vehicleUnloadType = vehicleUnloadType;
  }

  public String getVehicleTaskCode() {
    return vehicleTaskCode;
  }

  public void setVehicleTaskCode(String vehicleTaskCode) {
    this.vehicleTaskCode = vehicleTaskCode;
  }

  public String getVehicleCode() {
    return vehicleCode;
  }

  public void setVehicleCode(String vehicleCode) {
    this.vehicleCode = vehicleCode;
  }

  public String getVehicleName() {
    return vehicleName;
  }

  public void setVehicleName(String vehicleName) {
    this.vehicleName = vehicleName;
  }

  public String getSaleManAccount() {
    return saleManAccount;
  }

  public void setSaleManAccount(String saleManAccount) {
    this.saleManAccount = saleManAccount;
  }

  public String getSaleManName() {
    return saleManName;
  }

  public void setSaleManName(String saleManName) {
    this.saleManName = saleManName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public Set<VehicleUnloadProduct> getProducts() {
    return products;
  }

  public void setProducts(Set<VehicleUnloadProduct> products) {
    this.products = products;
  }

  public Integer getVehicleUnloadStatus() {
    return vehicleUnloadStatus;
  }

  public void setVehicleUnloadStatus(Integer vehicleUnloadStatus) {
    this.vehicleUnloadStatus = vehicleUnloadStatus;
  }

  public Integer getVehicleProductType() {
    return vehicleProductType;
  }

  public void setVehicleProductType(Integer vehicleProductType) {
    this.vehicleProductType = vehicleProductType;
  }

  public String getVehicleUnloadCode() {
    return vehicleUnloadCode;
  }

  public void setVehicleUnloadCode(String vehicleUnloadCode) {
    this.vehicleUnloadCode = vehicleUnloadCode;
  }

  public String getRelevanceCode() {
    return relevanceCode;
  }

  public void setRelevanceCode(String relevanceCode) {
    this.relevanceCode = relevanceCode;
  }

  public Date getVehicleUnloadTime() {
    return vehicleUnloadTime;
  }

  public void setVehicleUnloadTime(Date vehicleUnloadTime) {
    this.vehicleUnloadTime = vehicleUnloadTime;
  }
}
