package com.bizunited.empower.business.vehicle.entity;

import com.bizunited.platform.common.entity.TenantEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Author: wjx
 * @Date: 2021/3/30 10:07
 */
@ApiModel(value = "VehicleUserMapping", description = "车辆与业务员的关联表")
@Entity
@Table(name = "`vehicle_user_mapping`" , indexes = @Index(columnList = "tenant_code,vehicle_code,user_account "))
@org.hibernate.annotations.Table(appliesTo = "`vehicle_user_mapping`", comment = "车辆与业务员的关联表")
@BuildCustomRepository
public class VehicleUserMapping extends TenantEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 8341136752876844072L;

  /**
   * 车辆编码
   */
  @Column(name = "vehicle_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 车辆编码 '")
  @SaturnColumn(description = "车辆编码")
  @ApiModelProperty("车辆编码")
  private String vehicleCode;

  /**
   * 业务员账号
   */
  @Column(name = "user_account", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务员账号'")
  @SaturnColumn(description = "业务员账号")
  @ApiModelProperty("业务员账号")
  private String userAccount;

  /**
   * 业务员名称
   */
  @Column(name = "user_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务员名称'")
  @SaturnColumn(description = "业务员名称")
  @ApiModelProperty("业务员名称")
  private String userName;

  public String getVehicleCode() {
    return vehicleCode;
  }

  public void setVehicleCode(String vehicleCode) {
    this.vehicleCode = vehicleCode;
  }

  public String getUserAccount() {
    return userAccount;
  }

  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }

  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }
}
