package com.bizunited.empower.business.vehicle.repository;
import com.bizunited.empower.business.vehicle.entity.VehicleLoadProduct;
import com.bizunited.empower.business.vehicle.repository.internal.VehicleLoadProductRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * VehicleLoadProduct业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_VehicleLoadProductRepository")
public interface VehicleLoadProductRepository
    extends
      JpaRepository<VehicleLoadProduct, String>
      ,JpaSpecificationExecutor<VehicleLoadProduct>
      , VehicleLoadProductRepositoryCustom
  {
  /**
   * 按照车辆装货入库单进行详情查询（包括关联信息）
   * @param vehicleLoad 车辆装货入库单
   * */
  @Query("select distinct vehicleLoadProduct from VehicleLoadProduct vehicleLoadProduct "
      + " left join fetch vehicleLoadProduct.vehicleLoad vehicleLoadProduct_vehicleLoad "
       + " where vehicleLoadProduct_vehicleLoad.id = :id")
  Set<VehicleLoadProduct> findDetailsByVehicleLoad(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct vehicleLoadProduct from VehicleLoadProduct vehicleLoadProduct "
      + " left join fetch vehicleLoadProduct.vehicleLoad vehicleLoadProduct_vehicleLoad "
      + " where vehicleLoadProduct.id=:id ")
  VehicleLoadProduct findDetailsById(@Param("id") String id);



}