package com.bizunited.empower.business.vehicle.repository;

import com.bizunited.empower.business.vehicle.entity.VehicleLoad;
import com.bizunited.empower.business.vehicle.repository.internal.VehicleLoadRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * VehicleLoad业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_VehicleLoadRepository")
public interface VehicleLoadRepository
    extends
      JpaRepository<VehicleLoad, String>
      ,JpaSpecificationExecutor<VehicleLoad>
      , VehicleLoadRepositoryCustom
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct vehicleLoad from VehicleLoad vehicleLoad "
      + " where vehicleLoad.id=:id ")
  VehicleLoad findDetailsById(@Param("id") String id);

  /**
   * 根据装货单编号和租户编号查询
   * @param vehicleLoadCode
   * @param tenantCode
   * @return
   */
  @Query("from VehicleLoad v where v.vehicleLoadCode=:vehicleLoadCode and v.tenantCode = :tenantCode")
  VehicleLoad findByVehicleLoadCodeAndTenantCode(@Param("vehicleLoadCode") String vehicleLoadCode, @Param("tenantCode") String tenantCode);

  /**
   * 根据出车任务编码查询
   * @param vehicleTaskCode
   * @param tenantCode
   * @return
   */
  @Query("from VehicleLoad v where v.vehicleTaskCode=:vehicleTaskCode and v.tenantCode = :tenantCode order by v.createTime desc , v.id")
  List<VehicleLoad> findByVehicleTaskCodeAndTenantCode(@Param("vehicleTaskCode") String vehicleTaskCode, @Param("tenantCode") String tenantCode);

    /**
     * 根据出车任务编码和装货类型查询
     * @param vehicleTaskCode
     * @param tenantCode
     * @return
     */
    @Query("from VehicleLoad v where v.vehicleTaskCode=:vehicleTaskCode and v.vehicleLoadType = :vehicleLoadType and v.tenantCode = :tenantCode order by v.createTime desc ")
    List<VehicleLoad> findByVehicleTaskCodeAndVehicleLoadTypeAndTenantCode(@Param("vehicleTaskCode") String vehicleTaskCode, @Param("vehicleLoadType") Integer vehicleLoadType, @Param("tenantCode") String tenantCode);

  /**
   * 根据出车任务编码和车辆编码，查询退货入库信息
   * 注：只查询退货入库信息，且已确认状态的入库信息
   * @param vehicleTaskCode 任务编码
   * @param vehicleCode 车辆编码
   * @param tenantCode 租户编码
   */
  @Query("from VehicleLoad v where v.vehicleTaskCode=:vehicleTaskCode and  v.vehicleCode=:vehicleCode and v.tenantCode = :tenantCode and v.vehicleLoadStatus = 2")
  List<VehicleLoad> findByVehicleTaskCodeAndVehicleCodeAndTenantCode(@Param("vehicleTaskCode") String vehicleTaskCode,
                                                                     @Param("vehicleCode") String vehicleCode,
                                                                     @Param("tenantCode") String tenantCode);


  }