package com.bizunited.empower.business.vehicle.repository;

import com.bizunited.empower.business.vehicle.entity.VehicleProductStock;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * VehicleProductStock业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_VehicleProductStockRepository")
public interface VehicleProductStockRepository
    extends
      JpaRepository<VehicleProductStock, String>
      ,JpaSpecificationExecutor<VehicleProductStock>
  {
  /**
   * 按照车辆信息进行详情查询（包括关联信息）
   * @param id 车辆信息
   * */
  @Query("select distinct vehicleProductStock from VehicleProductStock vehicleProductStock "
      + " left join fetch vehicleProductStock.vehicle vehicleProductStock_vehicle "
       + " where vehicleProductStock_vehicle.id = :id")
  Set<VehicleProductStock> findDetailsByVehicle(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct vehicleProductStock from VehicleProductStock vehicleProductStock "
      + " left join fetch vehicleProductStock.vehicle vehicleProductStock_vehicle "
      + " where vehicleProductStock.id=:id ")
  VehicleProductStock findDetailsById(@Param("id") String id);

    /**
     * 根据租户编码 车辆编码 商品规格编码 车载商品类型 查询商品
     * @param tenantCode
     * @param vehicleCode
     * @param productSpecificationCode
     * @param vehicleProductType
     * @return
     */
  @Query("select vps from VehicleProductStock vps " +
          "inner join vps.vehicle v where v.tenantCode = :tenantCode " +
          "and v.vehicleCode = :vehicleCode " +
          "and vps.productSpecificationCode = :productSpecificationCode " +
          "and vps.vehicleProductType =:vehicleProductType")
  VehicleProductStock findByTenantCodeAndVehicleCodeAndProductSpecificationCode(@Param("tenantCode") String tenantCode,
                                                                                @Param("vehicleCode") String vehicleCode,
                                                                                @Param("productSpecificationCode") String productSpecificationCode,
                                                                                @Param("vehicleProductType") Integer vehicleProductType);

    /**
     * 根据租户编码 车辆编码 商品规格编码 车载商品类型 查询商品
     * @param tenantCode
     * @param vehicleCode
     * @param productSpecificationCodes
     * @param vehicleProductType
     * @return
     */
  @Query("select vps from VehicleProductStock vps " +
          "inner join vps.vehicle v where v.tenantCode = :tenantCode " +
          "and v.vehicleCode = :vehicleCode " +
          "and vps.productSpecificationCode in :productSpecificationCodes " +
          "and vps.vehicleProductType =:vehicleProductType")
  List<VehicleProductStock> findByTenantCodeAndVehicleCodeAndProductSpecificationCodes(@Param("tenantCode") String tenantCode,
                                                                                       @Param("vehicleCode") String vehicleCode,
                                                                                       @Param("productSpecificationCodes") List<String> productSpecificationCodes,
                                                                                       @Param("vehicleProductType") Integer vehicleProductType);

  /**
   * 根据车辆编码和租户编码删除
   * @param vehicleId
   * @param tenantCode
   */
  @Modifying
  @Query("delete from VehicleProductStock vps where vps.vehicle.id = :vehicleId and vps.tenantCode = :tenantCode")
  void deleteByVehicleIdAndTenantCode(@Param("vehicleId") String vehicleId, @Param("tenantCode") String tenantCode);

  /**
   *  查询当前车辆的有效车销车载库存
   * @param vehicleCode 车辆编码
   * @param tenantCode 租户编码
   */
  @Query("from VehicleProductStock v " +
          "left join fetch v.vehicle ve " +
          "where ve.vehicleCode=:vehicleCode and v.tenantCode=:tenantCode and v.vehicleProductType=2 and v.usableInventory > 0 " +
          "order by v.productSpecificationCode,v.unitCode")
  List<VehicleProductStock> findEffectiveVehicleSaleStockByVehicleCodeAndTenantCode(@Param("vehicleCode") String vehicleCode, @Param("tenantCode") String tenantCode);

  /**
   * 查询车辆中的所有库存
   * @param vehicleId
   * @param tenantCode
   * @return
   */
  @Modifying
  @Query(value = "select * from vehicle_product_stock v where v.vehicle_id = :vehicleId and v.tenant_code= :tenantCode",nativeQuery = true)
  List<VehicleProductStock> findByVehicleIdAndTenantCode(@Param("vehicleId") String vehicleId, @Param("tenantCode") String tenantCode);
  }