package com.bizunited.empower.business.vehicle.repository;

import com.bizunited.empower.business.vehicle.entity.VehicleUnloadProduct;
import com.bizunited.empower.business.vehicle.repository.internal.VehicleUnloadProductRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * VehicleUnloadProduct业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_VehicleUnloadProductRepository")
public interface VehicleUnloadProductRepository
    extends
      JpaRepository<VehicleUnloadProduct, String>
      ,JpaSpecificationExecutor<VehicleUnloadProduct>
      ,VehicleUnloadProductRepositoryCustom 
  {
  /**
   * 按照车辆卸货出库单进行详情查询（包括关联信息）
   * @param vehicleUnload 车辆卸货出库单
   * */
  @Query("select distinct vehicleUnloadProduct from VehicleUnloadProduct vehicleUnloadProduct "
      + " left join fetch vehicleUnloadProduct.vehicleUnload vehicleUnloadProduct_vehicleUnload "
       + " where vehicleUnloadProduct_vehicleUnload.id = :id")
  Set<VehicleUnloadProduct> findDetailsByVehicleUnload(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct vehicleUnloadProduct from VehicleUnloadProduct vehicleUnloadProduct "
      + " left join fetch vehicleUnloadProduct.vehicleUnload vehicleUnloadProduct_vehicleUnload "
      + " where vehicleUnloadProduct.id=:id ")
  VehicleUnloadProduct findDetailsById(@Param("id") String id);



}