package com.bizunited.empower.business.vehicle.repository;

import com.bizunited.empower.business.vehicle.entity.VehicleUserMapping;
import com.bizunited.empower.business.vehicle.repository.internal.VehicleUserMappingRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * VehicleUserMapping业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_VehicleUserMappingRepository")
public interface VehicleUserMappingRepository
    extends
      JpaRepository<VehicleUserMapping, String>
      ,JpaSpecificationExecutor<VehicleUserMapping>
      ,VehicleUserMappingRepositoryCustom 
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct vehicleUserMapping from VehicleUserMapping vehicleUserMapping "
      + " where vehicleUserMapping.id=:id ")
  VehicleUserMapping findDetailsById(@Param("id") String id);

  @Modifying
  @Query(value = "delete from vehicle_user_mapping where vehicle_code = :vehicleCode and tenant_code = :tenantCode", nativeQuery = true)
  void deleteByVehicleCodeAndTenantCode(@Param("vehicleCode") String vehicleCode, @Param("tenantCode") String tenantCode);

  @Query("from VehicleUserMapping v  where v.vehicleCode=:vehicleCode and v.tenantCode=:tenantCode")
  List<VehicleUserMapping> findByVehicleCode(@Param("vehicleCode") String vehicleCode, @Param("tenantCode") String tenantCode);

  /**
   * 根据用户账号查询
   * @param userAccount
   * @param tenantCode
   * @return
   */
  @Query("from VehicleUserMapping v  where v.userAccount=:userAccount and v.tenantCode=:tenantCode")
  List<VehicleUserMapping> findByUserAccount(@Param("userAccount") String userAccount, @Param("tenantCode") String tenantCode);
  }