package com.bizunited.empower.business.vehicle.repository.internal;

import com.bizunited.empower.business.vehicle.dto.VehicleProductStockDto;
import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.empower.business.vehicle.entity.VehicleProductStock;
import com.bizunited.empower.business.vehicle.vo.VehicleProductStockVo;
import com.bizunited.platform.script.context.InvokeParams;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * VehicleProductStock模型的数据层自定义接口，可以由程序员根据实际情况完善
 * @author saturn
 */
public interface VehicleProductStockRepositoryCustom {
  /**
   * 这是分页方法的雏形，可以根据业务要求进行修改
   */
  Page<VehicleProductStock> queryPage(Pageable pageable, InvokeParams conditions);

  /**
   * 分页查询
   * @param pageable
   * @return
   */
  Page<VehicleProductStock> findByConditions(Pageable pageable, VehicleProductStockDto dto, Vehicle vehicle);

  /**
   * 查询商品库存(去重并统计数量)
   * @param vehicleId
   * @param tenantCode
   * @return
   */
  List<VehicleProductStockVo> findProductStockStatistics(String vehicleId, String tenantCode);

  /**
   * 分页查询商品规格编号(去重)
   * @param pageable
   * @param dto
   * @param vehicle
   * @return
   */
  Page<String> findProductSpecificationCodeByConditions(Pageable pageable, VehicleProductStockDto dto, Vehicle vehicle);
}
