package com.bizunited.empower.business.vehicle.repository.internal;

import com.bizunited.empower.business.vehicle.dto.VehicleProductStockDto;
import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.empower.business.vehicle.entity.VehicleProductStock;
import com.bizunited.empower.business.vehicle.enums.VehicleProductTypeEnum;
import com.bizunited.empower.business.vehicle.vo.VehicleProductStockVo;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.script.context.InvokeParams;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * VehicleProductStock模型的数据层自定义接口实现，可以由程序员根据实际情况完善
 * @author saturn
 */
@Repository("_VehicleProductStockRepositoryImpl")
public class VehicleProductStockRepositoryImpl implements VehicleProductStockRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  @Override
  public Page<VehicleProductStock> queryPage(Pageable pageable, InvokeParams conditions) {
  StringBuilder hql = new StringBuilder("from VehicleProductStock c where 1=1");
  StringBuilder countHql = new StringBuilder("select count(*) FROM VehicleProductStock c where 1=1");
  StringBuilder condition = new StringBuilder();
  Map<String, Object> parameters = new HashMap<>();
  if (conditions != null) {
    // TODO 这里的代码需要开发人员自行完善——使用JPA
  }
  hql.append(condition);
  countHql.append(condition);
  return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }

  @Override
  public Page<VehicleProductStock> findByConditions(Pageable pageable, VehicleProductStockDto dto, Vehicle vehicle) {
    StringBuilder hql = new StringBuilder("select v from VehicleProductStock v where 1=1");
    StringBuilder countHql = new StringBuilder("select count(*) FROM VehicleProductStock v where 1=1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    if (dto != null) {
      this.buildParam(condition,dto,parameters,vehicle);
    }
    hql.append(condition).append(" order by v.id desc");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, VehicleProductStock.class);
  }

  @SuppressWarnings("unchecked")
  @Override
  public List<VehicleProductStockVo> findProductStockStatistics(String vehicleId, String tenantCode) {
    StringBuilder sql = new StringBuilder("select v.product_code as productCode,v.product_name as productName,v.product_specification_code as productSpecificationCode, v.vehicle_product_type as vehicleProductType,")
            .append("v.product_specification_name as productSpecificationName,v.unit_code as unitCode,v.unit_name as unitName,v.category_code as categoryCode,v.category_name as categoryName,")
            .append("v.bar_code as barCode,v.brand_code as brandCode,v.brand_name as brandName,v.relative_path as relativePath,v.file_name as fileName,sum(v.inventory) as inventory")
            .append(" from vehicle_product_stock v where 1=1");
    Map<String, Object> parameters = new HashMap<>();
    if (tenantCode != null) {
      sql.append(" and v.vehicle_id = :vehicleId ");
      parameters.put("vehicleId", vehicleId);
    }
    if (tenantCode != null) {
      sql.append(" and v.tenant_code = :tenantCode ");
      parameters.put("tenantCode", tenantCode);
    }
    sql.append("group by product_code,product_name,product_specification_code,vehicle_product_type,product_specification_name,unit_code,unit_name,brand_code,brand_name,category_code,category_name,bar_code,relative_path,file_name");
    Query nativeQuery = entityManager.createNativeQuery(sql.toString());
    parameters.forEach((k, v) -> {
      nativeQuery.setParameter(k, v);
    });
    List<VehicleProductStockVo> list = nativeQuery.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(VehicleProductStockVo.class)).list();
    return list;
  }

  @Override
  public Page<String> findProductSpecificationCodeByConditions(Pageable pageable, VehicleProductStockDto dto, Vehicle vehicle) {
    StringBuilder hql = new StringBuilder("select distinct v.productSpecificationCode from VehicleProductStock v where 1=1");
    StringBuilder countHql = new StringBuilder("select count(distinct v.productSpecificationCode) FROM VehicleProductStock v where 1=1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    if (dto != null) {
      this.buildParam(condition,dto,parameters,vehicle);
    }
    hql.append(condition);
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, String.class);
  }

  private void buildParam (StringBuilder condition , VehicleProductStockDto dto, Map<String, Object> parameters , Vehicle vehicle){
    if (StringUtils.isNotBlank(dto.getTenantCode())) {
      condition.append(" and v.tenantCode = :tenantCode ");
      parameters.put("tenantCode", dto.getTenantCode());
    }
    if (null!=vehicle) {
      condition.append(" and v.vehicle = :vehicle ");
      parameters.put("vehicle", vehicle);
    }
    if (StringUtils.isNotBlank(dto.getProductName())) {
      condition.append(" and v.productName like CONCAT('%',:productName,'%')");
      parameters.put("productName", dto.getProductName());
    }
    if (StringUtils.isNotBlank(dto.getBrandCode())) {
      condition.append(" and v.brandCode = :brandCode ");
      parameters.put("brandCode", dto.getBrandCode());
    }
    if (StringUtils.isNotBlank(dto.getCategoryCode())) {
      condition.append(" and v.categoryCode = :categoryCode ");
      parameters.put("categoryCode", dto.getCategoryCode());
    }
    if (null!=dto.getVehicleProductType()) {
      condition.append(" and v.vehicleProductType = :vehicleProductType ");
      parameters.put("vehicleProductType", dto.getVehicleProductType());
    }
    if (null != dto.getStock() && dto.getStock()){
      condition.append(" and v.usableInventory > 0 ");
    }
    if (null != dto.getSignType()){
      Integer vehicleProductType = 0;
      if (VehicleProductTypeEnum.VEHICLE_SALES.getType().equals(dto.getSignType())){
        vehicleProductType = VehicleProductTypeEnum.NOT_SALE.getType();
      }else if (VehicleProductTypeEnum.NOT_SALE.getType().equals(dto.getSignType())){
        vehicleProductType = VehicleProductTypeEnum.VEHICLE_SALES.getType();
      }
      condition.append(" and v.vehicleProductType = :vehicleProductType ");
      parameters.put("vehicleProductType", vehicleProductType);
    }
  }
}
