package com.bizunited.empower.business.vehicle.repository.internal;

import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.platform.script.context.InvokeParams;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Map;

/**
 * Vehicle模型的数据层自定义接口，可以由程序员根据实际情况完善
 * @author saturn
 */
public interface VehicleRepositoryCustom {
  /**
   * 这是分页方法的雏形，可以根据业务要求进行修改
   */
  Page<Vehicle> queryPage(Pageable pageable, InvokeParams conditions);

  /**
   * 分页查询
   * @param pageable
   * @param conditions
   * @return
   */
  Page<Vehicle> findByConditions(Pageable pageable, Map<String, Object> conditions);
}
