package com.bizunited.empower.business.vehicle.repository.internal;

import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.script.context.InvokeParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

/**
 * Vehicle模型的数据层自定义接口实现，可以由程序员根据实际情况完善
 * @author saturn
 */
public class VehicleRepositoryImpl implements VehicleRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  @Override
  public Page<Vehicle> queryPage(Pageable pageable, InvokeParams conditions) {
  StringBuilder hql = new StringBuilder("from Vehicle c where 1=1");
  StringBuilder countHql = new StringBuilder("select count(*) FROM Vehicle c where 1=1");
  StringBuilder condition = new StringBuilder();
  Map<String, Object> parameters = new HashMap<>();
  if (conditions != null) {
    // TODO 这里的代码需要开发人员自行完善——使用JPA
  }
  hql.append(condition);
  countHql.append(condition);
  return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }

  @Override
  public Page<Vehicle> findByConditions(Pageable pageable, Map<String, Object> conditions) {
    StringBuilder hql = new StringBuilder("select v from Vehicle v where 1=1");
    StringBuilder countHql = new StringBuilder("select count(*) FROM Vehicle v where 1=1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    if (conditions != null) {
      Integer vehicleStatus = (Integer) conditions.get("vehicleStatus");
      String carNumber = (String) conditions.get("carNumber");
      String vehicleName = (String) conditions.get("vehicleName");
      String tenantCode = (String) conditions.get("tenantCode");
      if (null != vehicleStatus) {
        condition.append(" and v.vehicleStatus = :vehicleStatus ");
        parameters.put("vehicleStatus", vehicleStatus);
      }
      if (StringUtils.isNotBlank(vehicleName)) {
        condition.append(" and v.vehicleName like CONCAT('%',:vehicleName,'%')");
        parameters.put("vehicleName", vehicleName);
      }
      if (StringUtils.isNotBlank(carNumber)) {
        condition.append(" and v.carNumber like CONCAT('%',:carNumber,'%')");
        parameters.put("carNumber", carNumber);
      }
      if (StringUtils.isNotBlank(tenantCode)) {
        condition.append(" and v.tenantCode = :tenantCode ");
        parameters.put("tenantCode", tenantCode);
      }
    }
    hql.append(condition).append("and v.delete = 0 order by v.createTime desc");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }
}
