package com.bizunited.empower.business.vehicle.service;

import com.bizunited.empower.business.vehicle.entity.VehicleProductStock;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * VehicleProductStock业务模型的服务层接口定义
 * @author saturn
 */
public interface VehicleProductStockService { 
  /**
   * 创建一个新的VehicleProductStock模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  VehicleProductStock create(VehicleProductStock vehicleProductStock);
  /**
   * 创建一个新的StudentEntity模型对象
   * 该代码由satrun骨架生成，默认不包括任何可能第三方系统调用、任何复杂逻辑处理等，主要应用场景为前端表单数据的暂存功能</br>
   * 该方法与本接口中的updateFrom方法呼应
   */
  VehicleProductStock createForm(VehicleProductStock vehicleProductStock);
  /**
   * 更新一个已有的VehicleProductStock模型对象，其主键属性必须有值(1.1.4-release版本调整)。
   * 这个方法实际上一共分为三个步骤（默认）：</br>
   * 1、调用updateValidation方法完成表单数据更新前的验证</br>
   * 2、调用updateForm方法完成表单数据的更新</br>
   * 3、完成开发人员自行在本update方法中书写的，进行第三方系统调用（或特殊处理过程）的执行。</br>
   * 这样做的目的，实际上是为了保证updateForm方法中纯粹是处理表单数据的，在数据恢复表单引擎默认调用updateForm方法时，不会影响任何第三方业务数据
   * （当然，如果系统有特别要求，可由开发人员自行完成代码逻辑调整）
   */
  VehicleProductStock update(VehicleProductStock vehicleProductStock);
  /**
   * 该方法只用于处理业务表单信息，包括了主业务模型、其下的关联模型、分组信息和明细细信息等
   * 该方法非常重要，因为如果进行静态表单的数据恢复，那么表单引擎将默认调用主业务模型（服务层）的这个方法。</br>
   * 这样一来保证了数据恢复时，不会涉及任何第三方系统的调用（当然，如果开发人员需要涉及的，可以自行进行修改）
   */
  VehicleProductStock updateForm(VehicleProductStock vehicleProductStock);
  /**
   * 按照关联的 车辆信息进行详情查询（包括关联信息）
   * @param vehicle 关联的 车辆信息
   */
  Set<VehicleProductStock> findDetailsByVehicle(String vehicle);

  /**
   * 根据车辆编码 商品类型查询车载库存
   * @param vehicleCode 关联的 车辆信息
   */
  List<VehicleProductStock> findByVehicleCodeAndProductTypeAndProductSpecificationCodes(String vehicleCode, Integer vehicleProductType, List<String> productSpecificationCodes);

  /**
   * 根据车辆编码 商品类型查询车载库存
   * @param vehicleCode 关联的 车辆信息
   */
  VehicleProductStock findByVehicleCodeAndProductTypeAndProductSpecificationCode(String vehicleCode, Integer vehicleProductType, String productSpecificationCode);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  VehicleProductStock findDetailsById(String id);
  /**
   * 按照VehicleProductStock的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  VehicleProductStock findById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  void deleteById(String id);

  /**
   * 车辆库存预占
   * @param productSpecificationCode 商品规格编号
   * @param vehicleCode 车辆编码
   * @param quantity 预占数量
   * @return
   */
  VehicleProductStock preemption(String productSpecificationCode, String vehicleCode, BigDecimal quantity, String unitCode, Integer vehicleProductType);

  /**
   * 取消车辆库存预占
   * @param productSpecificationCode 商品规格编号
   * @param vehicleCode 车辆编码
   * @param quantity 预占数量
   * @return
   */
  VehicleProductStock cancelPreemption(String productSpecificationCode, String vehicleCode, BigDecimal quantity, String unitCode, Integer vehicleProductType);

  /**
   * 批量保存 (适用于车仓为空的情况)
   * @param vehicleCode
   * @param vehicleProductStockList
   */
  void batchSave(String vehicleCode, List<VehicleProductStock> vehicleProductStockList);

  /**
   * 批量增加 (适用于车仓有商品的情况)
   * @param vehicleCode
   * @param vehicleProductStockList
   */
  void batchAdd(String vehicleCode, List<VehicleProductStock> vehicleProductStockList);

  /**
   * 预占的数据清空，库存消减
   * @param productSpecificationCode
   * @param vehicleCode
   * @param quantity
   */
  VehicleProductStock preemptionClose(String productSpecificationCode, String vehicleCode, BigDecimal quantity, String unitCode, Integer vehicleProductType);

  /**
   * 校验库存
   * @param productSpecificationCode
   * @param vehicleCode
   * @param quantity
   */
  Boolean validateVehicleStock(String productSpecificationCode, String vehicleCode, BigDecimal quantity, String unitCode, Integer vehicleProductType);

  /**
   * 转换基本单位
   * @param productSpecificationCode
   * @param quantity
   * @param unitCode
   * @return
   */
  BigDecimal conversionUnit(String productSpecificationCode, BigDecimal quantity, String unitCode);


  /**
   * 查询当前车辆的有效车载库存
   * @param vehicleCode 车辆编码
   */
  List<VehicleProductStock> findEffectiveVehicleSaleStockByVehicleCode(String vehicleCode);

  /**
   * 转换车辆商品类型  只支持转换存在车辆库存中的商品 (支持车销商品或配送商品转换为不可售商品 配送商品或不可售商品转为车销商品)
   * @param vehicleCode 车辆编码
   * @param productSpecificationCode 商品规格编号
   * @param quantity 转换数量 (基本单位数量)
   * @param oldType 转换前商品类型
   * @param newType 转换后商品类型
   */
  void transforVehicleProductType(String vehicleCode, String productSpecificationCode, BigDecimal quantity, Integer oldType, Integer newType);

}