package com.bizunited.empower.business.vehicle.service;

import com.bizunited.empower.business.vehicle.dto.VehicleProductStockDto;
import com.bizunited.empower.business.vehicle.vo.VehicleProductStockVo;
import com.bizunited.empower.business.vehicle.vo.VehicleStockQuantityVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * VehicleProductStockVo业务模型的服务层接口定义
 * @author saturn
 */
public interface VehicleProductStockVoService {

  /**
   * 根据车辆编码查询车辆库存数据
   * @param vehicleCode
   * @return
   */
  VehicleStockQuantityVo findStockByVehicleCode(String vehicleCode);

  /**
   * 分页查询
   * @param pageable
   * @return
   */
  Page<VehicleProductStockVo> findByConditions(Pageable pageable, VehicleProductStockDto dto);

  /**
   * 分页查询(根据商品分组聚合库存)
   * @param pageable
   * @param dto
   * @return
   */
  Page<VehicleProductStockVo> findProductByConditions(Pageable pageable, VehicleProductStockDto dto);
}