package com.bizunited.empower.business.vehicle.service;

import com.bizunited.empower.business.vehicle.entity.VehicleUnload;
import com.bizunited.empower.business.vehicle.enums.VehicleProductTypeEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleUnloadStatusEnum;

import java.util.List;

/**
 * VehicleUnload业务模型的服务层接口定义
 * @author saturn
 */
public interface VehicleUnloadService {
  /**
   * 创建一个新的VehicleUnload模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  VehicleUnload create(VehicleUnload vehicleUnload);
  /**
   * 创建一个新的StudentEntity模型对象
   * 该代码由satrun骨架生成，默认不包括任何可能第三方系统调用、任何复杂逻辑处理等，主要应用场景为前端表单数据的暂存功能</br>
   * 该方法与本接口中的updateFrom方法呼应
   */
  VehicleUnload createForm(VehicleUnload vehicleUnload);
  /**
   * 更新一个已有的VehicleUnload模型对象，其主键属性必须有值(1.1.4-release版本调整)。
   * 这个方法实际上一共分为三个步骤（默认）：</br>
   * 1、调用updateValidation方法完成表单数据更新前的验证</br>
   * 2、调用updateForm方法完成表单数据的更新</br>
   * 3、完成开发人员自行在本update方法中书写的，进行第三方系统调用（或特殊处理过程）的执行。</br>
   * 这样做的目的，实际上是为了保证updateForm方法中纯粹是处理表单数据的，在数据恢复表单引擎默认调用updateForm方法时，不会影响任何第三方业务数据
   * （当然，如果系统有特别要求，可由开发人员自行完成代码逻辑调整）
   */
  VehicleUnload update(VehicleUnload vehicleUnload);
  /**
   * 该方法只用于处理业务表单信息，包括了主业务模型、其下的关联模型、分组信息和明细细信息等
   * 该方法非常重要，因为如果进行静态表单的数据恢复，那么表单引擎将默认调用主业务模型（服务层）的这个方法。</br>
   * 这样一来保证了数据恢复时，不会涉及任何第三方系统的调用（当然，如果开发人员需要涉及的，可以自行进行修改）
   */
  VehicleUnload updateForm(VehicleUnload vehicleUnload);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  VehicleUnload findDetailsById(String id);
  /**
   * 按照VehicleUnload的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  VehicleUnload findById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  void deleteById(String id);

  /**
   * 根据卸货单编码执行车辆库存预占
   * @param vehicleUnloadCode
   * @return
   */
  VehicleUnload preemption(String vehicleUnloadCode);

  /**
   * 根据卸货但编码执行取消车辆库存预占
   * @param vehicleUnloadCode
   * @return
   */
  VehicleUnload cancelPreemption(String vehicleUnloadCode);


  /**
   * 根据卸货但编码执行预占的数据清空，库存消减
   * @param vehicleUnloadCode
   */
  VehicleUnload preemptionClose(String vehicleUnloadCode);

  /**
   * 根据卸货单编号查询
   * @param vehicleUnloadCode
   * @return
   */
  VehicleUnload findByVehicleUnloadCode(String vehicleUnloadCode);


  /**
   * 根据卸货单编码完成交货
   * @param vehicleUnloadCode
   */
  VehicleUnload deliveryVehicleUnload(String vehicleUnloadCode);

  /**
   * 根据卸货单编码取消卸货单
   * @param vehicleUnloadCode
   */
  void cancelVehicleUnload(String vehicleUnloadCode);

  /**
   * 保存卸货单以及商品
   * @param vehicleUnload
   */
  VehicleUnload saveVehicleUnload(VehicleUnload vehicleUnload);

  /**
   * 根据关联订单编码，查询卸货单
   * @param relevanceCode 关联订单编码
   * @return
   */
  VehicleUnload findByRelevanceCode(String relevanceCode);

  /**
   * 根据关联订单编码，取消卸货单
   * @param relevanceCode 关联订单编码
   */
  void cancelByRelevanceCode(String relevanceCode);

  /**
   * 根据出车任务编号和卸货单状态查询
   * @param vehicleTaskCode
   * @param vehicleUnloadStatusEnum
   * @return
   */
  List<VehicleUnload> findByVehicleTaskCodeAndUnloadStatus(String vehicleTaskCode, VehicleUnloadStatusEnum vehicleUnloadStatusEnum);

  /**
   * 查询类型为车销的 状态已完成的卸货单
   * @param vehicleTaskCode
   * @param vehicleUnloadStatusEnum
   * @return
   */
  List<VehicleUnload> findByVehicleTaskCodeAndProductTypeAndUnloadStatus(String vehicleTaskCode, VehicleProductTypeEnum vehicleProductType, VehicleUnloadStatusEnum vehicleUnloadStatusEnum);

  /**
   * 查询类型为车销的 状态已完成的卸货单
   * @param vehicleTaskCode
   * @return
   */
  List<VehicleUnload> findByVehicleTaskCodeAndProductType(String vehicleTaskCode, VehicleProductTypeEnum vehicleProductType);

  /**
   * 根据任务编号查询卸货记录
   * @param vehicleTaskCode
   * @return
   */
  List<VehicleUnload> findByVehicleTaskCode(String vehicleTaskCode);

  /**
   * 根据任务编号和车辆编号，查询卸货记录
   * 注：只查询运输途中出货，且非取消状态的出库信息
   * 包含车销出库和配送出库，不包含收车出库
   * @param vehicleTaskCode 出车任务编码
   * @param vehicleCode 车辆编码
   */
  List<VehicleUnload> findByVehicleTaskCodeAndVehicleCode(String vehicleTaskCode, String vehicleCode);

  /**
   * 根据出车任务编号和卸货单类型查询
   * @param vehicleTaskCode
   * @param VehicleUnloadType
   * @return
   */
  List<VehicleUnload> findByVehicleTaskCodeAndUnloadType(String vehicleTaskCode, Integer VehicleUnloadType);
}