package com.bizunited.empower.business.vehicle.service.internal;
import com.bizunited.empower.business.vehicle.entity.VehicleLoadProduct;
import com.bizunited.empower.business.vehicle.repository.VehicleLoadProductRepository;
import com.bizunited.empower.business.vehicle.service.VehicleLoadProductService;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.Optional;
import java.util.Set;

/**
 * VehicleLoadProduct业务模型的服务层接口实现
 * @author saturn
 */
@Service("VehicleLoadProductServiceImpl")
public class VehicleLoadProductServiceImpl implements VehicleLoadProductService { 
  @Autowired
  private VehicleLoadProductRepository vehicleLoadProductRepository;
  @Transactional
  @Override
  public VehicleLoadProduct create(VehicleLoadProduct vehicleLoadProduct) { 
    VehicleLoadProduct current = this.createForm(vehicleLoadProduct);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public VehicleLoadProduct createForm(VehicleLoadProduct vehicleLoadProduct) { 
   /* 
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    this.createValidation(vehicleLoadProduct);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    
    this.vehicleLoadProductRepository.save(vehicleLoadProduct);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return vehicleLoadProduct;
  }
  /**
   * 在创建一个新的VehicleLoadProduct模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(VehicleLoadProduct vehicleLoadProduct) { 
    Validate.notNull(vehicleLoadProduct , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(vehicleLoadProduct.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    vehicleLoadProduct.setId(null);
    Validate.notBlank(vehicleLoadProduct.getTenantCode(), "添加信息时，租户编号不能为空！");
    Validate.notBlank(vehicleLoadProduct.getProductCode(), "添加信息时，商品编码不能为空！");
    Validate.notBlank(vehicleLoadProduct.getProductName(), "添加信息时，商品名称不能为空！");
    Validate.notBlank(vehicleLoadProduct.getProductSpecificationCode(), "添加信息时，规格编号不能为空！");
    Validate.notBlank(vehicleLoadProduct.getProductSpecificationName(), "添加信息时，规格名称不能为空！");
    Validate.notBlank(vehicleLoadProduct.getUnitCode(), "添加信息时，单位编号不能为空！");
    Validate.notBlank(vehicleLoadProduct.getUnitName(), "添加信息时，单位名称不能为空！");
    Validate.notNull(vehicleLoadProduct.getQuantity(), "添加信息时，装货数量不能为空！");
    Validate.notNull(vehicleLoadProduct.getPurchasePrice(), "添加信息时，参考采购价，千位数代表.000不能为空！");
    Validate.notNull(vehicleLoadProduct.getSubtotalAmount(), "添加信息时，小计金额，千位数代表.000不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况）
    Validate.isTrue(vehicleLoadProduct.getTenantCode() == null || vehicleLoadProduct.getTenantCode().length() < 255 , "租户编号,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getProductCode() == null || vehicleLoadProduct.getProductCode().length() < 255 , "商品编码,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getProductName() == null || vehicleLoadProduct.getProductName().length() < 255 , "商品名称,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getRelativePath() == null || vehicleLoadProduct.getRelativePath().length() < 255 , "相对路径,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getFileName() == null || vehicleLoadProduct.getFileName().length() < 255 , "文件名,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getProductSpecificationCode() == null || vehicleLoadProduct.getProductSpecificationCode().length() < 64 , "规格编号,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getProductSpecificationName() == null || vehicleLoadProduct.getProductSpecificationName().length() < 128 , "规格名称,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getUnitCode() == null || vehicleLoadProduct.getUnitCode().length() < 64 , "单位编号,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getUnitName() == null || vehicleLoadProduct.getUnitName().length() < 128 , "单位名称,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getBarCode() == null || vehicleLoadProduct.getBarCode().length() < 255 , "条形码,在进行添加时填入值超过了限定长度(255)，请检查!");
  }
  @Transactional
  @Override
  public VehicleLoadProduct update(VehicleLoadProduct vehicleLoadProduct) { 
    VehicleLoadProduct current = this.updateForm(vehicleLoadProduct);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public VehicleLoadProduct updateForm(VehicleLoadProduct vehicleLoadProduct) { 
    /* 
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     * 
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    
    this.updateValidation(vehicleLoadProduct);
    // ===================基本信息
    String currentId = vehicleLoadProduct.getId();
    Optional<VehicleLoadProduct> op_currentVehicleLoadProduct = this.vehicleLoadProductRepository.findById(currentId);
    VehicleLoadProduct currentVehicleLoadProduct = op_currentVehicleLoadProduct.orElse(null);
    currentVehicleLoadProduct = Validate.notNull(currentVehicleLoadProduct ,"未发现指定的原始模型对象信");
    // 开始赋值——更新时间与更新人
    currentVehicleLoadProduct.setTenantCode(vehicleLoadProduct.getTenantCode());
    currentVehicleLoadProduct.setProductCode(vehicleLoadProduct.getProductCode());
    currentVehicleLoadProduct.setProductName(vehicleLoadProduct.getProductName());
    currentVehicleLoadProduct.setRelativePath(vehicleLoadProduct.getRelativePath());
    currentVehicleLoadProduct.setFileName(vehicleLoadProduct.getFileName());
    currentVehicleLoadProduct.setProductSpecificationCode(vehicleLoadProduct.getProductSpecificationCode());
    currentVehicleLoadProduct.setProductSpecificationName(vehicleLoadProduct.getProductSpecificationName());
    currentVehicleLoadProduct.setUnitCode(vehicleLoadProduct.getUnitCode());
    currentVehicleLoadProduct.setUnitName(vehicleLoadProduct.getUnitName());
    currentVehicleLoadProduct.setBarCode(vehicleLoadProduct.getBarCode());
    currentVehicleLoadProduct.setQuantity(vehicleLoadProduct.getQuantity());
    currentVehicleLoadProduct.setPurchasePrice(vehicleLoadProduct.getPurchasePrice());
    currentVehicleLoadProduct.setSubtotalAmount(vehicleLoadProduct.getSubtotalAmount());
    currentVehicleLoadProduct.setVehicleLoad(vehicleLoadProduct.getVehicleLoad());
    
    this.vehicleLoadProductRepository.saveAndFlush(currentVehicleLoadProduct);
    return currentVehicleLoadProduct;
  }
  /**
   * 在更新一个已有的VehicleLoadProduct模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(VehicleLoadProduct vehicleLoadProduct) { 
    Validate.isTrue(!StringUtils.isBlank(vehicleLoadProduct.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(vehicleLoadProduct.getTenantCode(), "修改信息时，租户编号不能为空！");
    Validate.notBlank(vehicleLoadProduct.getProductCode(), "修改信息时，商品编码不能为空！");
    Validate.notBlank(vehicleLoadProduct.getProductName(), "修改信息时，商品名称不能为空！");
    Validate.notBlank(vehicleLoadProduct.getProductSpecificationCode(), "修改信息时，规格编号不能为空！");
    Validate.notBlank(vehicleLoadProduct.getProductSpecificationName(), "修改信息时，规格名称不能为空！");
    Validate.notBlank(vehicleLoadProduct.getUnitCode(), "修改信息时，单位编号不能为空！");
    Validate.notBlank(vehicleLoadProduct.getUnitName(), "修改信息时，单位名称不能为空！");
    Validate.notNull(vehicleLoadProduct.getQuantity(), "修改信息时，装货数量不能为空！");
    Validate.notNull(vehicleLoadProduct.getPurchasePrice(), "修改信息时，参考采购价，千位数代表.000不能为空！");
    Validate.notNull(vehicleLoadProduct.getSubtotalAmount(), "修改信息时，小计金额，千位数代表.000不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(vehicleLoadProduct.getTenantCode() == null || vehicleLoadProduct.getTenantCode().length() < 255 , "租户编号,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getProductCode() == null || vehicleLoadProduct.getProductCode().length() < 255 , "商品编码,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getProductName() == null || vehicleLoadProduct.getProductName().length() < 255 , "商品名称,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getRelativePath() == null || vehicleLoadProduct.getRelativePath().length() < 255 , "相对路径,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getFileName() == null || vehicleLoadProduct.getFileName().length() < 255 , "文件名,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getProductSpecificationCode() == null || vehicleLoadProduct.getProductSpecificationCode().length() < 64 , "规格编号,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getProductSpecificationName() == null || vehicleLoadProduct.getProductSpecificationName().length() < 128 , "规格名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getUnitCode() == null || vehicleLoadProduct.getUnitCode().length() < 64 , "单位编号,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getUnitName() == null || vehicleLoadProduct.getUnitName().length() < 128 , "单位名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(vehicleLoadProduct.getBarCode() == null || vehicleLoadProduct.getBarCode().length() < 255 , "条形码,在进行修改时填入值超过了限定长度(255)，请检查!");
    
    // 关联性判断，关联属性判断，需要满足ManyToOne或者OneToOne，且not null 且是主模型
  } 
  @Override
  public Set<VehicleLoadProduct> findDetailsByVehicleLoad(String vehicleLoad) {
    if(StringUtils.isBlank(vehicleLoad)) {
      return Sets.newHashSet();
    }
    return this.vehicleLoadProductRepository.findDetailsByVehicleLoad(vehicleLoad);
  }
  @Override
  public VehicleLoadProduct findDetailsById(String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.vehicleLoadProductRepository.findDetailsById(id);
  }
  @Override
  public VehicleLoadProduct findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<VehicleLoadProduct> op = vehicleLoadProductRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    VehicleLoadProduct current = this.findById(id);
    if(current != null) { 
      this.vehicleLoadProductRepository.delete(current);
    }
  }

  @Override
  @Transactional
  public void batchSave(Set<VehicleLoadProduct> products) {
    if (!CollectionUtils.isEmpty(products)){
      vehicleLoadProductRepository.saveAll(products);
    }
  }
} 
