package com.bizunited.empower.business.vehicle.service.internal;

import com.bizunited.empower.business.vehicle.entity.VehicleUnloadProduct;
import com.bizunited.empower.business.vehicle.repository.VehicleUnloadProductRepository;
import com.bizunited.empower.business.vehicle.service.VehicleUnloadProductService;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.Optional;
import java.util.Set;

/**
 * VehicleUnloadProduct业务模型的服务层接口实现
 * @author saturn
 */
@Service("VehicleUnloadProductServiceImpl")
public class VehicleUnloadProductServiceImpl implements VehicleUnloadProductService {
  @Autowired
  private VehicleUnloadProductRepository vehicleUnloadProductRepository;
  @Transactional
  @Override
  public VehicleUnloadProduct create(VehicleUnloadProduct vehicleUnloadProduct) {
    VehicleUnloadProduct current = this.createForm(vehicleUnloadProduct);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public VehicleUnloadProduct createForm(VehicleUnloadProduct vehicleUnloadProduct) {
   /* 
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    this.createValidation(vehicleUnloadProduct);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    
    this.vehicleUnloadProductRepository.save(vehicleUnloadProduct);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return vehicleUnloadProduct;
  }
  /**
   * 在创建一个新的VehicleUnloadProduct模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(VehicleUnloadProduct vehicleUnloadProduct) {
    Validate.notNull(vehicleUnloadProduct , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(vehicleUnloadProduct.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    vehicleUnloadProduct.setId(null);
    Validate.notBlank(vehicleUnloadProduct.getTenantCode(), "添加信息时，租户编号不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getProductCode(), "添加信息时，商品编码不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getProductName(), "添加信息时，商品名称不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getProductSpecificationCode(), "添加信息时，规格编号不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getProductSpecificationName(), "添加信息时，规格名称不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getUnitCode(), "添加信息时，单位编号不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getUnitName(), "添加信息时，单位名称不能为空！");
    Validate.notNull(vehicleUnloadProduct.getQuantity(), "添加信息时，卸货数量不能为空！");
    Validate.notNull(vehicleUnloadProduct.getPurchasePrice(), "添加信息时，参考采购价，千位数代表.000不能为空！");
    Validate.notNull(vehicleUnloadProduct.getSubtotalAmount(), "添加信息时，小计金额，千位数代表.000不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况）
    Validate.isTrue(vehicleUnloadProduct.getTenantCode() == null || vehicleUnloadProduct.getTenantCode().length() < 255 , "租户编号,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getProductCode() == null || vehicleUnloadProduct.getProductCode().length() < 255 , "商品编码,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getProductName() == null || vehicleUnloadProduct.getProductName().length() < 255 , "商品名称,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getRelativePath() == null || vehicleUnloadProduct.getRelativePath().length() < 255 , "相对路径,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getFileName() == null || vehicleUnloadProduct.getFileName().length() < 255 , "文件名,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getProductSpecificationCode() == null || vehicleUnloadProduct.getProductSpecificationCode().length() < 64 , "规格编号,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getProductSpecificationName() == null || vehicleUnloadProduct.getProductSpecificationName().length() < 128 , "规格名称,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getUnitCode() == null || vehicleUnloadProduct.getUnitCode().length() < 64 , "单位编号,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getUnitName() == null || vehicleUnloadProduct.getUnitName().length() < 128 , "单位名称,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getBarCode() == null || vehicleUnloadProduct.getBarCode().length() < 255 , "条形码,在进行添加时填入值超过了限定长度(255)，请检查!");
  }
  @Transactional
  @Override
  public VehicleUnloadProduct update(VehicleUnloadProduct vehicleUnloadProduct) {
    VehicleUnloadProduct current = this.updateForm(vehicleUnloadProduct);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public VehicleUnloadProduct updateForm(VehicleUnloadProduct vehicleUnloadProduct) {
    /* 
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     * 
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    
    this.updateValidation(vehicleUnloadProduct);
    // ===================基本信息
    String currentId = vehicleUnloadProduct.getId();
    Optional<VehicleUnloadProduct> op_currentVehicleUnloadProduct = this.vehicleUnloadProductRepository.findById(currentId);
    VehicleUnloadProduct currentVehicleUnloadProduct = op_currentVehicleUnloadProduct.orElse(null);
    currentVehicleUnloadProduct = Validate.notNull(currentVehicleUnloadProduct ,"未发现指定的原始模型对象信");
    // 开始赋值——更新时间与更新人
    currentVehicleUnloadProduct.setTenantCode(vehicleUnloadProduct.getTenantCode());
    currentVehicleUnloadProduct.setProductCode(vehicleUnloadProduct.getProductCode());
    currentVehicleUnloadProduct.setProductName(vehicleUnloadProduct.getProductName());
    currentVehicleUnloadProduct.setRelativePath(vehicleUnloadProduct.getRelativePath());
    currentVehicleUnloadProduct.setFileName(vehicleUnloadProduct.getFileName());
    currentVehicleUnloadProduct.setProductSpecificationCode(vehicleUnloadProduct.getProductSpecificationCode());
    currentVehicleUnloadProduct.setProductSpecificationName(vehicleUnloadProduct.getProductSpecificationName());
    currentVehicleUnloadProduct.setUnitCode(vehicleUnloadProduct.getUnitCode());
    currentVehicleUnloadProduct.setUnitName(vehicleUnloadProduct.getUnitName());
    currentVehicleUnloadProduct.setBarCode(vehicleUnloadProduct.getBarCode());
    currentVehicleUnloadProduct.setQuantity(vehicleUnloadProduct.getQuantity());
    currentVehicleUnloadProduct.setPurchasePrice(vehicleUnloadProduct.getPurchasePrice());
    currentVehicleUnloadProduct.setSubtotalAmount(vehicleUnloadProduct.getSubtotalAmount());
    currentVehicleUnloadProduct.setVehicleUnload(vehicleUnloadProduct.getVehicleUnload());
    
    this.vehicleUnloadProductRepository.saveAndFlush(currentVehicleUnloadProduct);
    return currentVehicleUnloadProduct;
  }
  /**
   * 在更新一个已有的VehicleUnloadProduct模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(VehicleUnloadProduct vehicleUnloadProduct) {
    Validate.isTrue(!StringUtils.isBlank(vehicleUnloadProduct.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(vehicleUnloadProduct.getTenantCode(), "修改信息时，租户编号不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getProductCode(), "修改信息时，商品编码不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getProductName(), "修改信息时，商品名称不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getProductSpecificationCode(), "修改信息时，规格编号不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getProductSpecificationName(), "修改信息时，规格名称不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getUnitCode(), "修改信息时，单位编号不能为空！");
    Validate.notBlank(vehicleUnloadProduct.getUnitName(), "修改信息时，单位名称不能为空！");
    Validate.notNull(vehicleUnloadProduct.getQuantity(), "修改信息时，卸货数量不能为空！");
    Validate.notNull(vehicleUnloadProduct.getPurchasePrice(), "修改信息时，参考采购价，千位数代表.000不能为空！");
    Validate.notNull(vehicleUnloadProduct.getSubtotalAmount(), "修改信息时，小计金额，千位数代表.000不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(vehicleUnloadProduct.getTenantCode() == null || vehicleUnloadProduct.getTenantCode().length() < 255 , "租户编号,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getProductCode() == null || vehicleUnloadProduct.getProductCode().length() < 255 , "商品编码,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getProductName() == null || vehicleUnloadProduct.getProductName().length() < 255 , "商品名称,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getRelativePath() == null || vehicleUnloadProduct.getRelativePath().length() < 255 , "相对路径,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getFileName() == null || vehicleUnloadProduct.getFileName().length() < 255 , "文件名,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getProductSpecificationCode() == null || vehicleUnloadProduct.getProductSpecificationCode().length() < 64 , "规格编号,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getProductSpecificationName() == null || vehicleUnloadProduct.getProductSpecificationName().length() < 128 , "规格名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getUnitCode() == null || vehicleUnloadProduct.getUnitCode().length() < 64 , "单位编号,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getUnitName() == null || vehicleUnloadProduct.getUnitName().length() < 128 , "单位名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(vehicleUnloadProduct.getBarCode() == null || vehicleUnloadProduct.getBarCode().length() < 255 , "条形码,在进行修改时填入值超过了限定长度(255)，请检查!");
    
    // 关联性判断，关联属性判断，需要满足ManyToOne或者OneToOne，且not null 且是主模型
  } 
  @Override
  public Set<VehicleUnloadProduct> findDetailsByVehicleUnload(String vehicleUnload) {
    if(StringUtils.isBlank(vehicleUnload)) {
      return Sets.newHashSet();
    }
    return this.vehicleUnloadProductRepository.findDetailsByVehicleUnload(vehicleUnload);
  }
  @Override
  public VehicleUnloadProduct findDetailsById(String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.vehicleUnloadProductRepository.findDetailsById(id);
  }
  @Override
  public VehicleUnloadProduct findById(String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<VehicleUnloadProduct> op = vehicleUnloadProductRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    VehicleUnloadProduct current = this.findById(id);
    if(current != null) { 
      this.vehicleUnloadProductRepository.delete(current);
    }
  }

  @Override
  @Transactional
  public void batchSave(Set<VehicleUnloadProduct> products) {
    if (!CollectionUtils.isEmpty(products)){
      vehicleUnloadProductRepository.saveAll(products);
    }
  }
} 
