package com.bizunited.empower.business.vehicle.service.internal;

import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.empower.business.vehicle.entity.VehicleUserMapping;
import com.bizunited.empower.business.vehicle.service.VehicleService;
import com.bizunited.empower.business.vehicle.service.VehicleUserMappingService;
import com.bizunited.empower.business.vehicle.service.VehicleVoService;
import com.bizunited.empower.business.vehicle.vo.SaleManVo;
import com.bizunited.empower.business.vehicle.vo.VehicleVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @Author: wjx
 * @Date: 2021/4/1 14:44
 */
@Service("VehicleVoServiceImpl")
public class VehicleVoServiceImpl implements VehicleVoService {

  @Autowired
  private VehicleService vehicleService;
  @Autowired
  private VehicleUserMappingService vehicleUserMappingService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public VehicleVo create(VehicleVo vehicleVo) {
    Validate.notNull(vehicleVo, "进行当前操作时，信息对象必须传入!!");
    Vehicle vehicle = nebulaToolkitService.copyObjectByWhiteList(vehicleVo, Vehicle.class, HashSet.class, ArrayList.class);
    vehicle = vehicleService.create(vehicle);
    List<SaleManVo> userList = vehicleVo.getSaleManVos();
    if (!CollectionUtils.isEmpty(userList)){
      List<VehicleUserMapping> vehicleUserMappings = this.transformSaleManVoToVehicleUserMapping(userList, vehicle);
      vehicleUserMappingService.batchSave(vehicleUserMappings);
    }
    return vehicleVo;
  }

  @Override
  @Transactional
  public VehicleVo update(VehicleVo vehicleVo) {
    Validate.notNull(vehicleVo, "进行当前操作时，信息对象必须传入!!");
    Vehicle vehicle = nebulaToolkitService.copyObjectByWhiteList(vehicleVo, Vehicle.class, HashSet.class, ArrayList.class);
    vehicle = vehicleService.update(vehicle);
    vehicleUserMappingService.deleteByVehicleCode(vehicle.getVehicleCode());
    List<SaleManVo> userList = vehicleVo.getSaleManVos();
    if (!CollectionUtils.isEmpty(userList)){
      List<VehicleUserMapping> vehicleUserMappings = this.transformSaleManVoToVehicleUserMapping(userList, vehicle);
      vehicleUserMappingService.batchSave(vehicleUserMappings);
    }
    return vehicleVo;
  }

  private List<VehicleUserMapping> transformSaleManVoToVehicleUserMapping(List<SaleManVo> userList, Vehicle vehicle){
    List<VehicleUserMapping> vehicleUserMappings = new ArrayList<>();
    for (SaleManVo saleManVo : userList) {
      VehicleUserMapping vehicleUserMapping = new VehicleUserMapping();
      vehicleUserMapping.setTenantCode(TenantUtils.getTenantCode());
      vehicleUserMapping.setUserAccount(saleManVo.getUserAccount());
      vehicleUserMapping.setUserName(saleManVo.getUserName());
      vehicleUserMapping.setVehicleCode(vehicle.getVehicleCode());
      vehicleUserMappings.add(vehicleUserMapping);
    }
    return vehicleUserMappings;
  }

  @Override
  public VehicleVo findDetailsById(String id) {
    if(StringUtils.isBlank(id)) {
      return null;
    }
    Vehicle vehicle = vehicleService.findDetailsById(id);
    VehicleVo vehicleVo = nebulaToolkitService.copyObjectByWhiteList(vehicle, VehicleVo.class, HashSet.class, ArrayList.class);
    List<VehicleUserMapping> vehicleUserMappings = vehicleUserMappingService.findByVehicleCode(vehicleVo.getVehicleCode());
    if (!CollectionUtils.isEmpty(vehicleUserMappings)){
      List<SaleManVo> saleManVos = new ArrayList<>();
      for (VehicleUserMapping vehicleUserMapping : vehicleUserMappings) {
        SaleManVo saleManVo = new SaleManVo();
        saleManVo.setUserName(vehicleUserMapping.getUserName());
        saleManVo.setUserAccount(vehicleUserMapping.getUserAccount());
        saleManVos.add(saleManVo);
      }
      vehicleVo.setSaleManVos(saleManVos);
    }
    return vehicleVo;
  }
}
