package com.bizunited.empower.business.vehicle.vo;

import com.bizunited.platform.common.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @Author: wjx
 * @Date: 2021/4/1 11:37
 */
@ApiModel(value = "VehicleProductStockVo", description = "车辆商品库存vo")
public class VehicleProductStockVo extends TenantVo {


  private static final long serialVersionUID = -8116394405302386304L;
  /**
   * 车载商品类型  具体枚举见:com.bizunited.empower.terminal.staff.enums.vehicle.VehicleProductTypeEnum
   */
  @ApiModelProperty("车载商品类型 1配送商品 2车销商品 3不可售商品")
  private Integer vehicleProductType;

  /** 单位编号 */
  @ApiModelProperty("单位编号")
  private String unitCode;

  /** 单位名称 */
  @ApiModelProperty("单位名称")
  private String unitName;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 品牌编码
   */
  @ApiModelProperty("品牌编码")
  private String brandCode;

  /**
   * 品牌名称
   */
  @ApiModelProperty("品牌名称")
  private String brandName;

  /**
   * 分类名称
   */
  @ApiModelProperty("分类名称")
  private String categoryName;

  /**
   * 分类编码
   */
  @ApiModelProperty("分类编码")
  private String categoryCode;

  /**
   * 规格编码
   */
  @ApiModelProperty("规格编码")
  private String productSpecificationCode;

  /**
   * 规格名称
   */
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /** 相对路径 */
  @ApiModelProperty("相对路径")
  private String relativePath;

  /** 文件名 */
  @ApiModelProperty("文件名")
  private String fileName;

  /**
   * 条形码
   */
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 库存量 （后三位是小数的转换）
   */
  @ApiModelProperty("库存量（后三位是小数的转换）")
  private BigDecimal inventory;

  /**
   * 可用库存量 （后四位是小数的转换）
   */
  @ApiModelProperty("可用库存量（后三位是小数的转换）")
  private BigDecimal usableInventory;

  /**
   * 参考采购价
   */
  @ApiModelProperty("参考采购价，千位数代表.000")
  private BigDecimal purchasePrice;

  /** 小计金额 (行商品总价)*/
  @ApiModelProperty("小计金额，千位数代表.000")
  private BigDecimal subtotalAmount;


  //聚合库存数据
  /**
   * 车销可用库存量
   */
  @ApiModelProperty("车销可用库存量")
  private BigDecimal salesUsableInventory;

  /**
   * 配送可用库存量
   */
  @ApiModelProperty("配送可用库存量")
  private BigDecimal distributionUsableInventory;

  /**
   * 不可售库存量
   */
  @ApiModelProperty("不可售库存量")
  private BigDecimal notSaleUsableInventory;


  public Integer getVehicleProductType() {
    return vehicleProductType;
  }

  public void setVehicleProductType(Integer vehicleProductType) {
    this.vehicleProductType = vehicleProductType;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public String getUnitName() {
    return unitName;
  }

  public void setUnitName(String unitName) {
    this.unitName = unitName;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public String getBrandName() {
    return brandName;
  }

  public void setBrandName(String brandName) {
    this.brandName = brandName;
  }

  public String getCategoryName() {
    return categoryName;
  }

  public void setCategoryName(String categoryName) {
    this.categoryName = categoryName;
  }

  public String getCategoryCode() {
    return categoryCode;
  }

  public void setCategoryCode(String categoryCode) {
    this.categoryCode = categoryCode;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getBarCode() {
    return barCode;
  }

  public void setBarCode(String barCode) {
    this.barCode = barCode;
  }

  public BigDecimal getInventory() {
    return inventory;
  }

  public void setInventory(BigDecimal inventory) {
    this.inventory = inventory;
  }

  public BigDecimal getUsableInventory() {
    return usableInventory;
  }

  public void setUsableInventory(BigDecimal usableInventory) {
    this.usableInventory = usableInventory;
  }

  public BigDecimal getPurchasePrice() {
    return purchasePrice;
  }

  public void setPurchasePrice(BigDecimal purchasePrice) {
    this.purchasePrice = purchasePrice;
  }

  public BigDecimal getSubtotalAmount() {
    return subtotalAmount;
  }

  public void setSubtotalAmount(BigDecimal subtotalAmount) {
    this.subtotalAmount = subtotalAmount;
  }

  public BigDecimal getSalesUsableInventory() {
    return salesUsableInventory;
  }

  public void setSalesUsableInventory(BigDecimal salesUsableInventory) {
    this.salesUsableInventory = salesUsableInventory;
  }

  public BigDecimal getDistributionUsableInventory() {
    return distributionUsableInventory;
  }

  public void setDistributionUsableInventory(BigDecimal distributionUsableInventory) {
    this.distributionUsableInventory = distributionUsableInventory;
  }

  public BigDecimal getNotSaleUsableInventory() {
    return notSaleUsableInventory;
  }

  public void setNotSaleUsableInventory(BigDecimal notSaleUsableInventory) {
    this.notSaleUsableInventory = notSaleUsableInventory;
  }
}
