package com.bizunited.empower.business.vehicle.vo;

import com.bizunited.platform.common.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @Author: wjx
 * @Date: 2021/4/1 11:37
 */
@ApiModel(value = "VehicleStockQuantityVo", description = "车辆库存数量vo")
public class VehicleStockQuantityVo extends TenantVo {

  private static final long serialVersionUID = -3014287338497272103L;
  /**
   * 车辆编码
   */
  @ApiModelProperty("车辆编码")
  private String vehicleCode;

  /**
   * 商品数
   */
  @ApiModelProperty("商品数")
  private Long productQuantity;

  /**
   * 库存总件数
   */
  @ApiModelProperty("库存总件数")
  private BigDecimal stockProductTotal;

  public String getVehicleCode() {
    return vehicleCode;
  }

  public void setVehicleCode(String vehicleCode) {
    this.vehicleCode = vehicleCode;
  }

  public Long getProductQuantity() {
    return productQuantity;
  }

  public void setProductQuantity(Long productQuantity) {
    this.productQuantity = productQuantity;
  }

  public BigDecimal getStockProductTotal() {
    return stockProductTotal;
  }

  public void setStockProductTotal(BigDecimal stockProductTotal) {
    this.stockProductTotal = stockProductTotal;
  }
}
