package com.bizunited.empower.business.vehicle.vo;

import com.bizunited.empower.business.tenant.vo.TenantInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 转换车辆中商品类型vo
 * @Author: wjx
 * @Date: 2021/9/26 16:59
 */
@ApiModel(value = "VehicleTransforProductVo", description = "转换车辆中商品类型vo")
public class VehicleTransformProductTypeProductVo extends TenantInfoVo {

  /**
   * 规格编码
   */
  @ApiModelProperty("规格编码")
  private String productSpecificationCode;

  /**
   * 车载商品类型  具体枚举见:com.bizunited.empower.terminal.staff.enums.vehicle.VehicleProductTypeEnum
   */
  @ApiModelProperty("车载商品类型 1配送商品 2车销商品 3不可售商品")
  private Integer vehicleProductType;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  private BigDecimal quantity;

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public Integer getVehicleProductType() {
    return vehicleProductType;
  }

  public void setVehicleProductType(Integer vehicleProductType) {
    this.vehicleProductType = vehicleProductType;
  }

  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }
}
