package com.bizunited.empower.business.vehicle.vo;

import com.bizunited.platform.common.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Author: wjx
 * @Date: 2021/4/1 11:37
 */
@ApiModel(value = "VehicleVo", description = "车辆vo")
public class VehicleVo extends TenantVo {
  /**
   * 
   */
  private static final long serialVersionUID = -1336370889089851197L;

  /**
   * 车辆编码
   */
  @ApiModelProperty("车辆编码")
  private String vehicleCode;

  /**
   * 车辆名称
   */
  @ApiModelProperty("车辆名称")
  private String vehicleName;

  /**
   * 车牌号
   */
  @ApiModelProperty("车牌号")
  private String carNumber;

  /**
   * 车辆状态 具体枚举见：com.bizunited.empower.business.vehicle.enums.VehicleStatusEnum
   */
  @ApiModelProperty("车辆状态")
  private Integer vehicleStatus;

  /**
   * 车辆类型 具体枚举见：com.bizunited.empower.business.vehicle.enums.VehicleTypeEnum
   */
  @ApiModelProperty("车辆类型")
  private Integer vehicleType;

  /**
   * 动力类型 具体枚举见：com.bizunited.empower.business.vehicle.enums.PowerTypeEnum
   */
  @ApiModelProperty("动力类型")
  private String powerType;

  /**
   * 是否冷链
   */
  @ApiModelProperty("是否冷链")
  private Boolean coldChain;

  //货车参数

  /**
   * 总重量
   */
  @ApiModelProperty("总重量")
  private double weight;

  /**
   * 核定重量
   */
  @ApiModelProperty("核定重量")
  private double approvedWeight;

  /**
   * 车长
   */
  @ApiModelProperty("车长")
  private double length;

  /**
   * 车宽
   */
  @ApiModelProperty("车宽")
  private double wide;

  /**
   * 车高
   */
  @ApiModelProperty("车高")
  private double high;

  /**
   * 轴数 具体枚举见：com.bizunited.empower.business.vehicle.enums.AxesQuantityEnum
   */
  @ApiModelProperty("轴数")
  private String axesQuantity;

  /**
   * 排放标准 具体枚举见：com.bizunited.empower.business.vehicle.enums.EmissionStandardEnum
   */
  @ApiModelProperty("排放标准")
  private String emissionStandard;

  /**
   * 车牌颜色 具体枚举见：com.bizunited.empower.business.vehicle.enums.LicenseColorEnum
   */
  @ApiModelProperty("车牌颜色")
  private String licenseColor;

  /**
   * 货车用途 具体枚举见：com.bizunited.empower.business.vehicle.enums.PowerTypeEnum
   */
  @ApiModelProperty("货车用途")
  private String purpose;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 关联业务员
   */
  @ApiModelProperty("关联业务员")
  private List<SaleManVo> saleManVos;

  public String getVehicleCode() {
    return vehicleCode;
  }

  public void setVehicleCode(String vehicleCode) {
    this.vehicleCode = vehicleCode;
  }

  public String getVehicleName() {
    return vehicleName;
  }

  public void setVehicleName(String vehicleName) {
    this.vehicleName = vehicleName;
  }

  public String getCarNumber() {
    return carNumber;
  }

  public void setCarNumber(String carNumber) {
    this.carNumber = carNumber;
  }

  public Integer getVehicleStatus() {
    return vehicleStatus;
  }

  public void setVehicleStatus(Integer vehicleStatus) {
    this.vehicleStatus = vehicleStatus;
  }

  public Integer getVehicleType() {
    return vehicleType;
  }

  public void setVehicleType(Integer vehicleType) {
    this.vehicleType = vehicleType;
  }

  public String getPowerType() {
    return powerType;
  }

  public void setPowerType(String powerType) {
    this.powerType = powerType;
  }

  public Boolean getColdChain() {
    return coldChain;
  }

  public void setColdChain(Boolean coldChain) {
    this.coldChain = coldChain;
  }

  public double getWeight() {
    return weight;
  }

  public void setWeight(double weight) {
    this.weight = weight;
  }

  public double getApprovedWeight() {
    return approvedWeight;
  }

  public void setApprovedWeight(double approvedWeight) {
    this.approvedWeight = approvedWeight;
  }

  public double getLength() {
    return length;
  }

  public void setLength(double length) {
    this.length = length;
  }

  public double getWide() {
    return wide;
  }

  public void setWide(double wide) {
    this.wide = wide;
  }

  public double getHigh() {
    return high;
  }

  public void setHigh(double high) {
    this.high = high;
  }

  public String getAxesQuantity() {
    return axesQuantity;
  }

  public void setAxesQuantity(String axesQuantity) {
    this.axesQuantity = axesQuantity;
  }

  public String getEmissionStandard() {
    return emissionStandard;
  }

  public void setEmissionStandard(String emissionStandard) {
    this.emissionStandard = emissionStandard;
  }

  public String getLicenseColor() {
    return licenseColor;
  }

  public void setLicenseColor(String licenseColor) {
    this.licenseColor = licenseColor;
  }

  public String getPurpose() {
    return purpose;
  }

  public void setPurpose(String purpose) {
    this.purpose = purpose;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public List<SaleManVo> getSaleManVos() {
    return saleManVos;
  }

  public void setSaleManVos(List<SaleManVo> saleManVos) {
    this.saleManVos = saleManVos;
  }
}
