package com.bizunited.platform.dictionary.service.local.repository;

import com.bizunited.platform.dictionary.service.local.entity.DictImportEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 数据字典导入持久化
 * @Author: zengxingwang
 * @Date: 2020/5/20 10:12
 */
@Repository("DictImportRepository")
public interface DictImportRepository extends JpaRepository<DictImportEntity, String>, JpaSpecificationExecutor<DictImportEntity> {

  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  @Query("select di from DictImportEntity di left join fetch di.detail where di.id = :id")
  DictImportEntity findDetailsById(@Param("id") String id);
}
