package com.bizunited.platform.dictionary.service.local.repository;

import com.bizunited.platform.dictionary.service.local.entity.DictEntity;
import com.bizunited.platform.dictionary.service.local.entity.DictItemEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * DictItemRopositoy
 *
 * @description:
 * @author: yanwe
 * @date: 13/Feb/2019 10:40
 */
@Repository("DictItemRepository")
public interface DictItemRepository extends JpaRepository<DictItemEntity, String>, JpaSpecificationExecutor<DictItemEntity> {

    void deleteDictItemEntityByDictEntity(DictEntity dictEntity);

    List<DictItemEntity> findByDictEntity(DictEntity dictEntity);

    List<DictItemEntity> findByDictEntityOrderByDictSort(DictEntity dictEntity);

    @Query(value = "select di from DictItemEntity di left join di.dictEntity where di.id = :id")
    DictItemEntity findDetailById(@Param("id") String id);

  /**
   * 统计当前数据字段ID下的数据字典明细项Key
   * @param dictKey
   * @param dictId
   * @return
   */
  @Query("select count(*) from DictItemEntity di inner join di.dictEntity d where d.id = :dictId and di.dictKey = :dictKey ")
  long countByDictKeyAndDictId(@Param("dictKey") String dictKey, @Param("dictId") String dictId);


  /**
   * 统计当前数据字段ID下的数据字典明细项Value
   * @param dictValue
   * @param dictId
   * @return
   */
  @Query("select count(*) from DictItemEntity di inner join di.dictEntity d where d.id = :dictId and di.dictValue = :dictValue ")
  long countByDictValueAndDictId(@Param("dictValue") String dictValue, @Param("dictId") String dictId);

  /**
   * 根据字典dictCode和字典值的key查询一个数据字典值详细
   * @param dictCode
   * @param key
   * @return
   */
  @Query("select di from DictItemEntity di left join fetch di.dictEntity d where d.dictCode = :dictCode and di.dictKey = :key ")
  DictItemEntity findByKeyAndDictCode(@Param("dictCode") String dictCode, @Param("key") String key);
}
