package com.bizunited.platform.dictionary.service.local.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.constant.MigrateDataConstants;
import com.bizunited.platform.dictionary.common.service.DictExportService;
import com.bizunited.platform.dictionary.common.vo.DictExportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 数据字典导出
 * @Author: zengxingwang
 * @Date: 2020/5/20 21:13
 */
@Api(value = "DictExportController")
@RestController
@RequestMapping("/v1/nebula/dictExport")
public class DictExportController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(DictExportController.class);

  @Autowired
  private DictExportService dictExportService;

  /**
   * 查询导出日志
   * @return
   */
  @GetMapping("findAll")
  @ApiOperation("查询导出日志")
  public ResponseModel findAll() {
    try {
      List<DictExportVo> exports = dictExportService.findAll();
      return buildHttpResultW(exports, "createUser");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "导出指定编号的数据字典", notes = "传入导出的数据ID则按照传入的数据ID来导出，否则导出全部")
  @GetMapping("/exportDict")
  public void exportDict(@RequestParam(required = false) @ApiParam("筛选的数据ID") String[] dictIds, HttpServletRequest request, HttpServletResponse response) {
    try {
      byte[] bytes = this.dictExportService.exportDict(dictIds);
      Validate.isTrue(bytes != null && bytes.length != 0, "没有任何下载信息，很大几率原因是导出逻辑出现错误!!");
      String time = new SimpleDateFormat(MigrateDataConstants.EXPORT_FILENAME_DATE_FORMAT).format(new Date());
      String fileName = StringUtils.join("数据字典-", time, ".zip");
      writeResponseFile(request, response, bytes, fileName);
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      this.printResponseModel(this.buildHttpResultForException(e), response);
    }
  }
}
